/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sparkgap;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.electricity.sparkgap.SparkGapBlock;
import org.patryk3211.powergrid.electricity.sparkgap.SparkGapValueBehaviour;
import org.patryk3211.powergrid.utility.Lang;

public class SparkGapBlockEntity
extends ElectricBlockEntity {
    private SwitchedWire plasmaChannel;
    protected SparkGapValueBehaviour setting;

    public SparkGapBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.setting = new SparkGapValueBehaviour((class_2561)Lang.translateDirect("devices.spark_gap.voltage", new Object[0]), this, (ValueBoxTransform)new BoxTransform());
        behaviours.add((BlockEntityBehaviour)this.setting);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236 && this.plasmaChannel.getState()) {
            class_243 center = this.field_11867.method_46558().method_1023(0.0, 0.125, 0.0);
            float offset = (1.0f + (float)(this.setting.getValue() * 3) / 18.0f) / 16.0f;
            class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654((class_2769)SparkGapBlock.HORIZONTAL_AXIS);
            class_243 end = center.method_43206(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056), (double)offset);
            class_243 start = center.method_43206(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060), (double)offset);
            this.field_11863.method_8406((class_2394)new ZapParticleData(end.field_1352, end.field_1351, end.field_1350, true).withLife(1).withSegments(5), start.field_1352, start.field_1351, start.field_1350, 0.0, 0.0, 0.0);
        }
        if (!this.plasmaChannel.getState() && Math.abs(this.plasmaChannel.potentialDifference()) > (float)this.setting.getVoltage()) {
            this.plasmaChannel.setState(true);
            this.notifyUpdate();
        } else if (this.plasmaChannel.getState() && Math.abs(this.plasmaChannel.current()) < this.setting.getCurrent()) {
            this.plasmaChannel.setState(false);
            this.notifyUpdate();
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.plasmaChannel.setState(tag.method_10577("State"));
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("State", this.plasmaChannel.getState());
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.plasmaChannel = builder.connectSwitch(1.0f, builder.terminalNode(0), builder.terminalNode(1), false);
    }

    public static class BoxTransform
    extends CenteredSideValueBoxTransform {
        public BoxTransform() {
            super((state, dir) -> dir == class_2350.field_11036);
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)8.5);
        }
    }
}

