/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsScreen;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1268;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlock;
import org.patryk3211.powergrid.network.packets.TransformerWindingC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class TransformerWindingScreen
extends ValueSettingsScreen {
    public static final class_2960 CAP_TEXTURE = PowerGrid.texture("gui/brass_cover");
    private final class_1268 hand;
    private int cap;
    private static int interactionTicks = -1;
    private static TransformerWindingScreen screen = null;

    public static ValueSettingsBoard makeBoard(TransformerBlock block) {
        return new ValueSettingsBoard((class_2561)Lang.translateDirect("gui.transformer.turns", new Object[0]), block.getMaxTurns(), 10, List.of(class_2561.method_43470((String)"N")), new ValueSettingsFormatter(TransformerWindingScreen::formatSettings));
    }

    public static class_5250 formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return Lang.number(Math.max(1, Math.abs(settings.value()))).component();
    }

    public static boolean beginInteraction(Supplier<TransformerWindingScreen> potentialScreen) {
        if (interactionTicks == -1) {
            interactionTicks = 0;
            screen = potentialScreen.get();
            return true;
        }
        return false;
    }

    public TransformerWindingScreen(TransformerBlock block, class_1268 hand, int current, int primaryTurns) {
        super(null, TransformerWindingScreen.makeBoard(block), new ValueSettingsBehaviour.ValueSettings(0, current), setting -> {}, 1000);
        this.hand = hand;
        this.cap = block.getMaxTurns() - primaryTurns;
    }

    public ValueSettingsBehaviour.ValueSettings getClosestCoordinate(int mouseX, int mouseY) {
        ValueSettingsBehaviour.ValueSettings value = super.getClosestCoordinate(mouseX, mouseY);
        if (value.value() > this.cap) {
            return new ValueSettingsBehaviour.ValueSettings(value.row(), this.cap);
        }
        return value;
    }

    public static void renderCropped(class_332 graphics, int x, int y, int width, int height, int u, int v) {
        int left = x;
        int top = y;
        int right = left + width;
        int bot = top + height;
        float u1 = (float)u / 256.0f;
        float v1 = (float)v / 256.0f;
        float u2 = u1 + (float)width / 256.0f;
        float v2 = v1 + (float)height / 256.0f;
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        Color c = Color.WHITE;
        boolean z = false;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34541);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferbuilder.method_22918(m, (float)left, (float)bot, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u1, v2).method_1344();
        bufferbuilder.method_22918(m, (float)right, (float)bot, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u2, v2).method_1344();
        bufferbuilder.method_22918(m, (float)right, (float)top, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u2, v1).method_1344();
        bufferbuilder.method_22918(m, (float)left, (float)top, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u1, v1).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }

    public void renderBarCap(class_332 graphics, int x, int y, int width, ValueSettingsBoard board) {
        int milestoneCount = board.maxValue() / board.milestoneInterval();
        int milestoneSegmentWidth = width / milestoneCount;
        int scale = board.maxValue() > 128 ? 1 : 2;
        int milestone = this.cap / board.milestoneInterval();
        int toMilestoneOffset = milestoneSegmentWidth * milestone + 8 / scale;
        float milestoneFraction = (float)(this.cap - milestone * board.milestoneInterval()) / (float)board.milestoneInterval();
        int offset = (int)((float)toMilestoneOffset + (float)(milestoneSegmentWidth - 7 + 1) * milestoneFraction);
        x += offset;
        --x;
        width -= offset;
        if ((width += 2) <= 2) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)CAP_TEXTURE);
        int sideWidth = Math.min(3, width / 2);
        int centerWidth = width - sideWidth * 2;
        TransformerWindingScreen.renderCropped(graphics, x, y, sideWidth, 10, 0, 0);
        TransformerWindingScreen.renderCropped(graphics, x + sideWidth + centerWidth, y, Math.min(3, width - sideWidth), 10, 253, 0);
        for (int w = 0; w < centerWidth; w += 249) {
            int segLen = Math.min(249, centerWidth - w);
            int segX = x + w + sideWidth;
            TransformerWindingScreen.renderCropped(graphics, segX, y, segLen, 10, 3, 0);
        }
    }

    public void renderBarCapMilestone(class_332 graphics, int x, int y, int milestone, ValueSettingsBoard board) {
        int milestoneValue = milestone * board.milestoneInterval();
        if (milestoneValue > this.cap) {
            graphics.method_25302(CAP_TEXTURE, x, y + 1, 0, 11, 7, 8);
        }
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettingsBehaviour.ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        int value = Math.max(closest.value(), 1);
        ModdedPackets.getChannel().sendToServer((Object)new TransformerWindingC2SPacket(value, this.hand));
        this.method_25419();
    }

    public static void clientTick() {
        if (interactionTicks == -1) {
            return;
        }
        if (++interactionTicks <= 3) {
            class_310 mc = class_310.method_1551();
            if (!mc.field_1690.field_1904.method_1434()) {
                interactionTicks = -1;
                return;
            }
            if (interactionTicks == 3) {
                ScreenOpener.open((class_437)screen);
            }
        } else {
            interactionTicks = -1;
        }
    }
}

