/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.wire.ClientWireInteractions;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.IComplexRaycast;

public class BlockWireEntity
extends WireEntity
implements IComplexRaycast {
    public class_238 mainBoundingBox;
    public final List<class_238> boundingBoxes = new ArrayList<class_238>();
    public final List<Point> segments = new ArrayList<Point>();
    private float totalLength = 0.0f;
    private boolean particlesSpawned = false;

    public BlockWireEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public static BlockWireEntity create(class_1937 world, IWireEndpoint endpoint1, class_1799 item, List<Point> segments) {
        if (!(item.method_7909() instanceof WireItem)) {
            throw new IllegalArgumentException("ItemStack must be of a WireItem");
        }
        BlockWireEntity entity = new BlockWireEntity((class_1299)ModdedEntities.BLOCK_WIRE.get(), world);
        entity.setItem((WireItem)item.method_7909(), item.method_7947());
        class_243 pos = BlockTrace.alignPosition(endpoint1.getExactPosition(world));
        entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        entity.segments.addAll(segments);
        entity.bakeBoundingBoxes();
        entity.setEndpoint1(endpoint1);
        entity.method_36456(0.0f);
        entity.method_36457(0.0f);
        entity.method_22862();
        entity.method_23311();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    public static BlockWireEntity create(class_1937 world, class_243 pos, class_1799 item, List<Point> segments) {
        if (!(item.method_7909() instanceof WireItem)) {
            throw new IllegalArgumentException("ItemStack must be of a WireItem");
        }
        BlockWireEntity entity = new BlockWireEntity((class_1299)ModdedEntities.BLOCK_WIRE.get(), world);
        entity.setItem((WireItem)item.method_7909(), item.method_7947());
        entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        entity.segments.addAll(segments);
        entity.bakeBoundingBoxes();
        entity.method_36456(0.0f);
        entity.method_36457(0.0f);
        entity.method_22862();
        entity.method_23311();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    protected class_238 method_33332() {
        if (this.mainBoundingBox != null) {
            return this.mainBoundingBox.method_997(this.method_19538());
        }
        return super.method_33332();
    }

    public void bakeBoundingBoxes() {
        this.boundingBoxes.clear();
        this.totalLength = 0.0f;
        class_243 currentPos = class_243.field_1353;
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Point segment : this.segments) {
            segment.start = currentPos.method_1019(this.method_19538());
            class_243 nextPos = currentPos.method_1019(segment.vector());
            if (nextPos.field_1352 > maxX) {
                maxX = nextPos.field_1352;
            }
            if (nextPos.field_1351 > maxY) {
                maxY = nextPos.field_1351;
            }
            if (nextPos.field_1350 > maxZ) {
                maxZ = nextPos.field_1350;
            }
            if (nextPos.field_1352 < minX) {
                minX = nextPos.field_1352;
            }
            if (nextPos.field_1351 < minY) {
                minY = nextPos.field_1351;
            }
            if (nextPos.field_1350 < minZ) {
                minZ = nextPos.field_1350;
            }
            this.boundingBoxes.add(new class_238(currentPos, nextPos).method_1014(0.0625));
            currentPos = nextPos;
            this.totalLength += segment.length();
        }
        this.mainBoundingBox = new class_238(minX, minY, minZ, maxX, maxY, maxZ).method_1014(0.0625);
        this.method_5857(this.method_33332());
    }

    public float getTotalLength() {
        return this.totalLength;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        float temperature = this.getTemperature();
        class_243 pos = this.method_19538();
        if (this.isOverheated()) {
            if (world.field_9236 && !this.particlesSpawned) {
                for (Point segment : this.segments) {
                    class_243 dir = segment.vector();
                    int pointCount = Math.round(segment.length() / 0.25f);
                    for (int i = 0; i < pointCount; ++i) {
                        float r = (float)i / (float)pointCount;
                        double x = segment.start.field_1352 + dir.field_1352 * (double)r;
                        double y = segment.start.field_1351 + dir.field_1351 * (double)r;
                        double z = segment.start.field_1350 + dir.field_1350 * (double)r;
                        world.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                this.particlesSpawned = true;
            }
        } else if (temperature >= this.overheatTemperature - 50.0f && world.field_9236) {
            Point segment = this.segments.get(this.field_5974.method_43048(this.segments.size()));
            class_243 dir = segment.vector();
            float r = this.field_5974.method_43057();
            double x = segment.start.field_1352 + dir.field_1352 * (double)r;
            double y = segment.start.field_1351 + dir.field_1351 * (double)r;
            double z = segment.start.field_1350 + dir.field_1350 * (double)r;
            world.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, (double)0.05f, 0.0);
        }
    }

    @Nullable
    public class_1542 method_5699(class_1799 stack, float yOffset) {
        if (stack.method_7960()) {
            return null;
        }
        if (this.method_37908().field_9236) {
            return null;
        }
        class_243 center = this.mainBoundingBox.method_1005();
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317() + center.field_1352, this.method_23318() + (double)yOffset + center.field_1351, this.method_23321() + center.field_1350, stack);
        itemEntity.method_6988();
        this.method_37908().method_8649((class_1297)itemEntity);
        return itemEntity;
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.segments.clear();
        class_2499 segmentList = nbt.method_10554("Segments", 10);
        for (class_2520 segment : segmentList) {
            Point point = new Point((class_2487)segment);
            this.segments.add(point);
        }
        this.bakeBoundingBoxes();
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2499 segmentList = new class_2499();
        for (Point segment : this.segments) {
            segmentList.add((Object)segment.serialize());
        }
        nbt.method_10566("Segments", (class_2520)segmentList);
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof WireItem) {
            WireItem wire = (WireItem)class_17922;
            if (player.method_37908().field_9236) {
                return ClientWireInteractions.attachWire(this);
            }
            return class_1269.field_21466;
        }
        if (stack.method_7909() == ModdedItems.WIRE_CUTTER.get()) {
            if (player.method_5715()) {
                return super.method_5688(player, hand);
            }
            if (player.method_37908().field_9236) {
                return ClientWireInteractions.segmentCut(this);
            }
            return class_1269.field_21466;
        }
        return super.method_5688(player, hand);
    }

    @Override
    @Nullable
    public class_243 raycast(class_243 min, class_243 max) {
        class_243 closestHit = null;
        min = min.method_1020(this.method_19538());
        max = max.method_1020(this.method_19538());
        double distance = max.method_1025(min);
        for (class_238 bb : this.boundingBoxes) {
            double hitDistance;
            Optional hit = bb.method_992(min, max);
            if (hit.isEmpty() || !((hitDistance = ((class_243)hit.get()).method_1025(min)) < distance)) continue;
            distance = hitDistance;
            closestHit = ((class_243)hit.get()).method_1019(this.method_19538());
        }
        return closestHit;
    }

    @Override
    public void endpointRemoved(IWireEndpoint endpoint) {
        Point removedSegment;
        if (endpoint.equals(this.getEndpoint2())) {
            removedSegment = this.segments.remove(this.segments.size() - 1);
            this.setEndpoint2(null);
        } else if (endpoint.equals(this.getEndpoint1())) {
            removedSegment = this.segments.remove(0);
            this.method_33574(this.method_19538().method_1019(removedSegment.vector()));
            this.setEndpoint1(null);
        } else {
            return;
        }
        int items = (int)removedSegment.length();
        if (items > 0 && !this.method_37908().field_9236) {
            class_243 start = removedSegment.start;
            class_243 vector = removedSegment.vector();
            if (this.getWireCount() <= items) {
                --items;
            }
            class_1542 itemEntity = new class_1542(this.method_37908(), start.field_1352 + vector.field_1352, start.field_1351 + vector.field_1351, start.field_1350 + vector.field_1350, new class_1799((class_1935)this.getWireItem(), items));
            itemEntity.method_6988();
            this.method_37908().method_8649((class_1297)itemEntity);
            this.incrementWireCount(-items);
        }
        this.dropWire();
        this.sendExtraData();
    }

    public BlockWireEntity flip() {
        BlockWireEntity entity = new BlockWireEntity((class_1299)ModdedEntities.BLOCK_WIRE.get(), this.method_37908());
        entity.setItem(this.getWireItem(), this.getWireCount());
        entity.setEndpoint1(this.getEndpoint2());
        entity.setEndpoint2(this.getEndpoint1());
        entity.method_5841().method_12778(TEMPERATURE, (Object)Float.valueOf(this.getTemperature()));
        entity.setColor(this.getColor());
        class_243 pos = this.method_19538();
        for (int i = 0; i < this.segments.size(); ++i) {
            Point segment = this.segments.get(i);
            pos = pos.method_1019(segment.vector());
            class_2350 dir = segment.direction.method_10153();
            int length = segment.gridLength;
            if (length <= 0) continue;
            entity.segments.add(0, new Point(dir, length));
        }
        entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        entity.bakeBoundingBoxes();
        entity.method_36456(0.0f);
        entity.method_36457(0.0f);
        entity.method_22862();
        entity.method_23311();
        this.method_31472();
        class_3218 serverWorld = (class_3218)this.method_37908();
        serverWorld.method_30736((class_1297)entity);
        return entity;
    }

    public void extend(List<Point> points, int newItems, boolean notify) {
        if (this.method_37908().field_9236) {
            return;
        }
        this.incrementWireCount(newItems);
        this.segments.addAll(points);
        this.bakeBoundingBoxes();
        if (notify) {
            this.sendExtraData();
        }
    }

    public void extend(List<Point> points, int newItems) {
        this.extend(points, newItems, true);
    }

    public JunctionWireEndpoint split(int segmentIndex, int segmentPoint) {
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            return null;
        }
        Point segment = this.segments.get(segmentIndex);
        class_243 junctionPos = segment.start.method_43206(segment.direction, (double)((float)segmentPoint / 16.0f));
        JunctionWireEndpoint junction = new JunctionWireEndpoint(junctionPos);
        BlockWireEntity wire2 = new BlockWireEntity((class_1299)ModdedEntities.BLOCK_WIRE.get(), world);
        wire2.setColor(this.getColor());
        wire2.setItem(this.getWireItem(), 0);
        Point splitSegment = new Point(segment.direction, segment.gridLength - segmentPoint);
        wire2.segments.add(splitSegment);
        this.segments.set(segmentIndex, new Point(segment.direction, segmentPoint - 1));
        float movedLength = splitSegment.length();
        int removeCount = this.segments.size() - segmentIndex - 1;
        for (int i = 0; i < removeCount; ++i) {
            Point removed = this.segments.remove(segmentIndex + 1);
            wire2.segments.add(removed);
            movedLength += removed.length();
        }
        wire2.method_23327(junctionPos.field_1352, junctionPos.field_1351, junctionPos.field_1350);
        wire2.bakeBoundingBoxes();
        this.bakeBoundingBoxes();
        wire2.method_36456(0.0f);
        wire2.method_36457(0.0f);
        wire2.method_22862();
        wire2.method_23311();
        int items = (int)movedLength;
        wire2.incrementWireCount(items);
        wire2.method_5841().method_12778(TEMPERATURE, (Object)Float.valueOf(this.getTemperature()));
        wire2.setEndpoint2(this.getEndpoint2());
        wire2.setEndpoint1(junction);
        this.setEndpoint2(junction);
        class_3218 serverWorld = (class_3218)world;
        serverWorld.method_30736((class_1297)wire2);
        this.sendExtraData();
        return junction;
    }

    public static class Point {
        public class_243 start;
        public final class_2350 direction;
        public final int gridLength;

        public Point(class_2350 direction, int gridLength) {
            this.direction = direction;
            this.gridLength = gridLength;
        }

        public Point(class_2487 tag) {
            this.direction = class_2350.method_10143((int)tag.method_10550("Direction"));
            this.gridLength = tag.method_10550("Length");
        }

        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            tag.method_10569("Direction", this.direction.method_10146());
            tag.method_10569("Length", this.gridLength);
            return tag;
        }

        public float length() {
            return (float)this.gridLength / 16.0f;
        }

        public class_243 vector() {
            float length = this.length();
            return switch (this.direction) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11034 -> new class_243((double)length, 0.0, 0.0);
                case class_2350.field_11039 -> new class_243((double)(-length), 0.0, 0.0);
                case class_2350.field_11036 -> new class_243(0.0, (double)length, 0.0);
                case class_2350.field_11033 -> new class_243(0.0, (double)(-length), 0.0);
                case class_2350.field_11035 -> new class_243(0.0, 0.0, (double)length);
                case class_2350.field_11043 -> new class_243(0.0, 0.0, (double)(-length));
            };
        }

        public static Point x(float length) {
            return new Point(length >= 0.0f ? class_2350.field_11034 : class_2350.field_11039, (int)(Math.abs(length) * 16.0f));
        }

        public static Point y(float length) {
            return new Point(length >= 0.0f ? class_2350.field_11036 : class_2350.field_11033, (int)(Math.abs(length) * 16.0f));
        }

        public static Point z(float length) {
            return new Point(length >= 0.0f ? class_2350.field_11035 : class_2350.field_11043, (int)(Math.abs(length) * 16.0f));
        }
    }
}

