/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class BlockWireEntityEndpoint
implements IWireEndpoint {
    private class_2338 entityPos;
    private UUID entityId;
    private boolean end;

    public BlockWireEntityEndpoint() {
        this.entityPos = null;
        this.entityId = null;
        this.end = false;
    }

    public BlockWireEntityEndpoint(BlockWireEntity entity, boolean end) {
        this.entityPos = entity.method_24515();
        this.entityId = entity.method_5667();
        this.end = end;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.BLOCK_WIRE;
    }

    @Override
    public void read(class_2487 nbt) {
        this.entityId = nbt.method_25926("Id");
        int[] posArray = nbt.method_10561("Pos");
        this.entityPos = new class_2338(posArray[0], posArray[1], posArray[2]);
        this.end = nbt.method_10577("End");
    }

    @Override
    public void write(class_2487 nbt) {
        nbt.method_25927("Id", this.entityId);
        nbt.method_10539("Pos", new int[]{this.entityPos.method_10263(), this.entityPos.method_10264(), this.entityPos.method_10260()});
        nbt.method_10556("End", this.end);
    }

    public BlockWireEntity getEntity(class_1937 world) {
        List entityList = world.method_8390(BlockWireEntity.class, new class_238(this.entityPos), e -> e.method_5667().equals(this.entityId));
        if (entityList.isEmpty()) {
            return null;
        }
        return (BlockWireEntity)entityList.get(0);
    }

    @Override
    @NotNull
    public class_243 getExactPosition(class_1937 world) {
        BlockWireEntity entity = this.getEntity(world);
        if (entity == null) {
            return this.entityPos.method_46558();
        }
        if (!this.end) {
            return entity.method_19538();
        }
        class_243 pos = entity.method_19538();
        for (BlockWireEntity.Point segment : entity.segments) {
            pos = pos.method_1019(segment.vector());
        }
        return pos;
    }

    public boolean getEnd() {
        return this.end;
    }

    @Override
    public OwnedFloatingNode getNode(class_1937 world) {
        return null;
    }

    @Override
    public void assignWireEntity(BaseWireEntity entity) {
    }

    @Override
    public void removeWireEntity(BaseWireEntity entity) {
    }
}

