/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;

@Environment(value=EnvType.CLIENT)
public class BlockWireRenderer
extends class_897<BlockWireEntity> {
    public BlockWireRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(BlockWireEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.isOverheated()) {
            return;
        }
        class_243 currentPos = class_243.field_1353;
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23572((class_2960)this.getTextureLocation(entity)));
        class_243 pos = entity.method_19538();
        int color = entity.getColor() | 0xFF000000;
        boolean first = true;
        for (BlockWireEntity.Point segment : entity.segments) {
            float length = segment.length();
            if (first) {
                currentPos = class_243.field_1353.method_43206(segment.direction, -0.0625);
                length += 0.0625f;
                first = false;
            }
            class_2382 normal = segment.direction.method_10163();
            class_243 newPos = currentPos.method_1031((double)((float)normal.method_10263() * length), (double)((float)normal.method_10264() * length), (double)((float)normal.method_10260() * length));
            int calcLight = 0;
            for (class_2350 dir : class_2350.values()) {
                int skyLight;
                if (dir.method_10166() == segment.direction.method_10166()) continue;
                class_2382 n = dir.method_10163();
                class_2338 blockPos = class_2338.method_49637((double)(newPos.field_1352 + pos.field_1352 + (double)((float)n.method_10263() / 16.0f)), (double)(newPos.field_1351 + pos.field_1351 + (double)((float)n.method_10264() / 16.0f)), (double)(newPos.field_1350 + pos.field_1350 + (double)((float)n.method_10260() / 16.0f)));
                int blockLight = entity.method_37908().method_8314(class_1944.field_9282, blockPos);
                int newLight = class_765.method_23687((int)blockLight, (int)(skyLight = entity.method_37908().method_8314(class_1944.field_9284, blockPos)));
                if (newLight <= calcLight) continue;
                calcLight = newLight;
            }
            BlockWireRenderer.renderSegment(matrices, buffer, calcLight, color, currentPos, segment.direction, entity.getWireItem().getWireThickness(), length, entity.method_5628());
            currentPos = newPos;
        }
    }

    public class_2960 getTextureLocation(BlockWireEntity entity) {
        return entity.getWireItem().getWireTexture();
    }

    public static void debugLine(class_4587 ms, class_4588 buffer, int light, int color, class_243 v1, class_243 v2) {
        Matrix4f matrix = ms.method_23760().method_23761();
        buffer.method_22918(matrix, (float)v1.field_1352, (float)v1.field_1351, (float)v1.field_1350).method_39415(color).method_22916(light).method_1344();
        buffer.method_22918(matrix, (float)v2.field_1352, (float)v2.field_1351, (float)v2.field_1350).method_39415(color).method_22916(light).method_1344();
    }

    private static void vertex(class_4587.class_4665 matrix, class_4588 buffer, float x1, float y1, float z1, float u, float v, float xn, float yn, float zn, int color, int light) {
        buffer.method_22918(matrix.method_23761(), x1, y1, z1).method_39415(color).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix.method_23762(), xn, yn, zn).method_1344();
    }

    public static void renderSegment(class_4587 ms, class_4588 buffer, int light, int color, class_243 start, class_2350 dir, float thickness, float length, int uvOffset) {
        if (dir.method_10171() == class_2350.class_2352.field_11060) {
            length *= -1.0f;
            thickness *= -1.0f;
        }
        float u0 = (float)(uvOffset %= 16) / 16.0f;
        float v0 = (float)uvOffset / 16.0f;
        float t0 = (float)uvOffset / 16.0f;
        float u1 = thickness + (float)uvOffset / 16.0f;
        float v1 = thickness + (float)uvOffset / 16.0f;
        float t1 = thickness + (float)uvOffset / 16.0f;
        float x1 = (float)start.field_1352 - thickness / 2.0f;
        float y1 = (float)start.field_1351 - thickness / 2.0f;
        float z1 = (float)start.field_1350 - thickness / 2.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float z2 = 0.0f;
        switch (dir.method_10166()) {
            case field_11048: {
                x1 += (thickness *= 0.995f);
                x2 = length - thickness;
                u0 = 0.0f;
                u1 = Math.abs(length);
                break;
            }
            case field_11052: {
                y1 += thickness;
                y2 = length - thickness;
                v0 = 0.0f;
                v1 = Math.abs(length);
                break;
            }
            case field_11051: {
                z1 += (thickness *= 1.005f);
                z2 = length - thickness;
                t0 = 0.0f;
                t1 = Math.abs(length);
            }
        }
        x2 += x1 + thickness;
        y2 += y1 + thickness;
        z2 += z1 + thickness;
        if (dir.method_10171() == class_2350.class_2352.field_11060) {
            float xb = x1;
            float yb = y1;
            float zb = z1;
            x1 = x2;
            y1 = y2;
            z1 = z2;
            x2 = xb;
            y2 = yb;
            z2 = zb;
        }
        class_4587.class_4665 matrix = ms.method_23760();
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, t1, u0, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, t1, u1, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, t0, u1, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, t0, u0, 0.0f, -1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, t0, u1, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, t1, u1, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, t1, u0, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, t0, u0, 0.0f, 1.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, t0, v1, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, t1, v1, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, t1, v0, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, t0, v0, -1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, t1, v0, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, t1, v1, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, t0, v1, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, t0, v0, 1.0f, 0.0f, 0.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z1, u0, v0, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z1, u0, v1, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z1, u1, v1, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z1, u1, v0, 0.0f, 0.0f, -1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y1, z2, u0, v0, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y1, z2, u1, v0, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x2, y2, z2, u1, v1, 0.0f, 0.0f, 1.0f, color, light);
        BlockWireRenderer.vertex(matrix, buffer, x1, y2, z2, u0, v1, 0.0f, 0.0f, 1.0f, color, light);
    }
}

