/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.createmod.ponder.api.level.PonderLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3965;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.CurveParameters;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.electricity.wire.WirePreview;
import org.patryk3211.powergrid.network.packets.EntityDataS2CPacket;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.IComplexRaycast;

public class HangingWireEntity
extends WireEntity
implements IComplexRaycast {
    public static final int CLEARANCE_CHECK_INTERVAL = 20;
    private static final class_243 UP = new class_243(0.0, 1.0, 0.0);
    public class_243 terminalPos1;
    public class_243 terminalPos2;
    private boolean particlesSpawned = false;
    public Object renderParams;
    private int clearanceCheck = 0;

    public HangingWireEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public static boolean checkClearance(class_1937 world, class_243 start, class_243 end) {
        class_3965 result = BlockTrace.raycast(world, start, end);
        if (result.method_17783() == class_239.class_240.field_1332) {
            if (world.field_9236) {
                WirePreview.notifyOfBlock(result.method_17777());
            }
            return false;
        }
        return true;
    }

    public void updateRenderParams() {
        if (!this.method_37908().field_9236) {
            return;
        }
        WireItem item = this.getWireItem();
        this.renderParams = new CurveParameters(this.terminalPos1, this.terminalPos2, item.getHorizontalCoefficient(), item.getVerticalCoefficient(), item.getWireThickness());
        this.method_5857(this.method_33332());
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_238 calculateClientBoundingBox() {
        if (this.renderParams == null) {
            return null;
        }
        CurveParameters curve = (CurveParameters)this.renderParams;
        class_238 box = new class_238(this.terminalPos1, this.terminalPos2);
        MutableFloat minY = new MutableFloat((Number)box.field_1322);
        float eY = (float)this.method_19538().field_1351;
        curve.runForSegments((x1, y1, z1, x2, y2, z2, offset, length) -> {
            float y = (y1 + y2) * 0.5f + eY;
            if (y < minY.getValue().floatValue()) {
                minY.setValue(y);
            }
        });
        return box.method_35575((double)minY.getValue().floatValue()).method_1014((double)0.1f);
    }

    public static HangingWireEntity create(class_1937 world, BlockWireEndpoint endpoint1, BlockWireEndpoint endpoint2, class_1799 item, @Nullable Float resistance) {
        if (!(item.method_7909() instanceof WireItem)) {
            throw new IllegalArgumentException("ItemStack must be of a WireItem");
        }
        HangingWireEntity entity = new HangingWireEntity((class_1299)ModdedEntities.HANGING_WIRE.get(), world);
        entity.setItem((WireItem)item.method_7909(), item.method_7947());
        entity.resistanceOverride = resistance;
        entity.setEndpoint1(endpoint1);
        entity.setEndpoint2(endpoint2);
        entity.refreshTerminalPositions();
        entity.method_36457(0.0f);
        entity.method_22862();
        entity.method_23311();
        if (entity.getWireItem().canBeColored()) {
            entity.setColor(4275249);
        }
        return entity;
    }

    protected class_238 method_33332() {
        if (this.terminalPos1 != null && this.terminalPos2 != null) {
            class_238 box;
            if (this.method_37908().field_9236 && (box = this.calculateClientBoundingBox()) != null) {
                return box;
            }
            box = new class_238(this.terminalPos1, this.terminalPos2);
            return box.method_1014((double)0.1f);
        }
        return super.method_33332();
    }

    @Override
    public void method_5773() {
        byte beginFlags = this.deferEndpointResolution;
        super.method_5773();
        class_1937 world = this.method_37908();
        if (beginFlags != this.deferEndpointResolution) {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            this.updateRenderParams();
        }
        float temperature = this.getTemperature();
        class_243 pos = this.method_19538();
        if (this.isOverheated()) {
            if (world.field_9236 && !this.particlesSpawned) {
                CurveParameters curveParams = (CurveParameters)this.renderParams;
                float dx = curveParams.getCurveSpan();
                int pointCount = Math.round(dx / 0.25f);
                curveParams.runForPoints(pointCount, (x, y, z) -> world.method_8406((class_2394)class_2398.field_11240, pos.field_1352 + (double)x, pos.field_1351 + (double)y, pos.field_1350 + (double)z, 0.0, 0.0, 0.0));
                this.particlesSpawned = true;
            }
        } else if (temperature >= this.overheatTemperature - 50.0f && world.field_9236 && this.renderParams != null) {
            class_243 curvePoint = ((CurveParameters)this.renderParams).getRandomPoint(this.field_5974);
            double x2 = curvePoint.field_1352 + pos.field_1352;
            double y2 = curvePoint.field_1351 + pos.field_1351;
            double z2 = curvePoint.field_1350 + pos.field_1350;
            world.method_8406((class_2394)class_2398.field_11251, x2, y2, z2, 0.0, (double)0.05f, 0.0);
        }
        if (!world.field_9236 && this.clearanceCheck++ >= 20 && this.terminalPos1 != null && this.terminalPos2 != null) {
            this.clearanceCheck = 0;
            class_3965 result = BlockTrace.raycast(world, this.terminalPos1, this.terminalPos2);
            if (result.method_17783() == class_239.class_240.field_1332) {
                BlockWireEndpoint block;
                BlockWireEndpoint block2;
                IWireEndpoint iWireEndpoint = this.getEndpoint1();
                if (iWireEndpoint instanceof BlockWireEndpoint ? (block2 = (BlockWireEndpoint)iWireEndpoint).getPos().equals((Object)result.method_17777()) : (iWireEndpoint = this.getEndpoint2()) instanceof BlockWireEndpoint && (block = (BlockWireEndpoint)iWireEndpoint).getPos().equals((Object)result.method_17777())) {
                    return;
                }
                this.method_5768();
            }
        }
    }

    @Override
    public void endpointRemoved(IWireEndpoint endpoint) {
        if (endpoint.equals(this.getEndpoint1()) || endpoint.equals(this.getEndpoint2())) {
            this.method_5768();
        }
    }

    public boolean method_5863() {
        return EnvExecutor.getInEnv((Env)Env.CLIENT, () -> () -> {
            Object patt0$temp = this.renderParams;
            if (patt0$temp instanceof CurveParameters) {
                CurveParameters rp = (CurveParameters)patt0$temp;
                return rp.isVertical();
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void onEntityDataPacket(class_2487 data) {
        if (data.method_10545("V")) {
            class_2499 list = data.method_10554("V", 5);
            this.terminalPos1 = new class_243((double)list.method_10604(0), (double)list.method_10604(1), (double)list.method_10604(2));
            this.terminalPos2 = new class_243((double)list.method_10604(3), (double)list.method_10604(4), (double)list.method_10604(5));
            this.updateRenderParams();
        } else {
            super.onEntityDataPacket(data);
        }
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.getEndpoint1() == null || this.getEndpoint2() == null) {
            this.method_5768();
            return;
        }
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            this.refreshTerminalPositions();
        } else {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            this.updateRenderParams();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_243 raycast(class_243 min, class_243 max) {
        if (this.getWireItem() == null) {
            return null;
        }
        float thickness = this.getWireItem().getWireThickness() * 2.0f;
        Object object = this.renderParams;
        if (object instanceof CurveParameters) {
            CurveParameters params = (CurveParameters)object;
            class_243 ray = max.method_1020(min);
            double rayLength = ray.method_1027();
            ray = ray.method_1029();
            class_243 planeOrigin = this.method_19538();
            class_243 planeNormal = this.method_5828(1.0f);
            class_243 planeOriginVector = planeOrigin.method_1020(min);
            class_243 planeYVector = new class_243(0.0, 1.0, 0.0);
            class_243 planeXVector = planeNormal.method_1036(planeYVector);
            if (ray.field_1352 * ray.field_1352 + ray.field_1350 * ray.field_1350 < ray.field_1351 * ray.field_1351 * 0.25) {
                double planeDistance = planeOriginVector.method_1026(planeYVector);
                double hitDistance = planeDistance / planeYVector.method_1026(ray);
                if (hitDistance * hitDistance < rayLength) {
                    class_243 hit = min.method_1019(ray.method_1021(hitDistance));
                    class_243 hitOriginVector = hit.method_1020(planeOrigin);
                    double parallelDistance = Math.abs(planeXVector.method_1026(hitOriginVector));
                    double perpendicularDistance = Math.abs(planeNormal.method_1026(hitOriginVector));
                    if (parallelDistance < (double)(params.getCurveSpan() / 2.0f) && perpendicularDistance < (double)(thickness / 2.0f)) {
                        return hit;
                    }
                    return null;
                }
            } else {
                double planeDistance = planeOriginVector.method_1026(planeNormal);
                double hitDistance = planeDistance / planeNormal.method_1026(ray);
                if (hitDistance > 0.0 && hitDistance * hitDistance < rayLength) {
                    double dY;
                    class_243 hit = min.method_1019(ray.method_1021(hitDistance));
                    class_243 hitOriginVector = hit.method_1020(planeOrigin);
                    double x = planeXVector.method_1026(hitOriginVector);
                    double y = hitOriginVector.field_1351;
                    double closeX = params.findClosestPoint(x, y);
                    double span = params.getCurveSpan() / 2.0f;
                    double dX = x - (closeX = Math.min(Math.max(closeX, -span), span));
                    double squareDistance = dX * dX + (dY = y - (double)params.apply((float)closeX)) * dY;
                    if (squareDistance < (double)(thickness * thickness)) {
                        return hit;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void flipEndpoints() {
        super.flipEndpoints();
        this.refreshTerminalPositions();
    }

    public void refreshTerminalPositions() {
        class_1937 world = this.method_37908();
        if (world != null && (!world.field_9236 || world instanceof PonderLevel)) {
            this.terminalPos1 = this.getEndpoint1().getExactPosition(world);
            this.terminalPos2 = this.getEndpoint2().getExactPosition(world);
            class_243 vect = this.terminalPos2.method_1020(this.terminalPos1);
            class_243 facing = vect.method_1036(UP);
            float facingAngle = (float)(Math.atan2(facing.field_1352, -facing.field_1350) * 180.0 / Math.PI);
            this.method_5814((this.terminalPos1.field_1352 + this.terminalPos2.field_1352) * 0.5, this.terminalPos1.field_1351, (this.terminalPos1.field_1350 + this.terminalPos2.field_1350) * 0.5);
            this.method_36456(facingAngle);
            if (!world.field_9236) {
                class_2487 tag = new class_2487();
                class_2499 list = new class_2499();
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos1.field_1352)));
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos1.field_1351)));
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos1.field_1350)));
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos2.field_1352)));
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos2.field_1351)));
                list.add((Object)class_2494.method_23244((float)((float)this.terminalPos2.field_1350)));
                tag.method_10566("V", (class_2520)list);
                EntityDataS2CPacket packet = new EntityDataS2CPacket(this, tag);
                ModdedPackets.sendToClientsTracking(packet, this);
            }
        }
    }
}

