/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;

public abstract class WireEntity
extends BaseWireEntity {
    private ElectricWire wire;

    public WireEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public void setWire(ElectricWire wire) {
        this.wire = wire;
    }

    public ElectricWire getWire() {
        return this.wire;
    }

    @Override
    public float current() {
        return this.wire == null || !this.wire.isConverged() ? 0.0f : this.wire.current();
    }

    @Override
    public void makeWire() {
        class_1937 world = this.method_37908();
        if (world.field_9236 && !(world instanceof PonderLevel)) {
            return;
        }
        this.dropWire();
        if (this.endpoint1 == null || this.endpoint2 == null) {
            return;
        }
        if (!this.endpoint1.isValid(world) || !this.endpoint2.isValid(world)) {
            return;
        }
        try {
            this.wire = GlobalElectricNetworks.makeConnection(world, this.endpoint1, this.endpoint2, this, new WorldNetworks.SimpleId(this.method_5667()));
        }
        catch (RuntimeException e) {
            PowerGrid.LOGGER.error("Failed to create wire for entity", (Throwable)e);
            this.method_5768();
        }
    }

    @Override
    public void dropWire() {
        if (this.wire != null) {
            this.wire.remove();
            this.wire = null;
        }
    }

    public static void entityUnload(class_1297 entity, class_3218 world) {
        if (!(entity instanceof WireEntity)) {
            return;
        }
        WireEntity wire = (WireEntity)entity;
        ElectricWire electricWire = wire.wire;
        if (electricWire instanceof TransmissionLinePart) {
            TransmissionLinePart part = (TransmissionLinePart)electricWire;
            class_1297.class_5529 reason = wire.method_35049();
            if (reason != null && reason.method_31486()) {
                wire.dropWire();
            } else {
                part.unload();
                wire.wire = null;
            }
        } else {
            wire.dropWire();
        }
    }
}

