/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.multimeter;

import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.ClientElectricNetwork;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.CircuitBoardEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.network.packets.MultimeterDataC2SPacket;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class MultimeterItem
extends class_1792
implements IHaveElectricProperties {
    public static final float MAX_DISTANCE = 5.0f;

    public MultimeterItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        if (context.method_20287() != class_1268.field_5808) {
            return super.method_7884(context);
        }
        IElectric electric = IElectric.getAt(context.method_8045(), context.method_8037());
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (electric != null) {
            class_2338 pos = context.method_8037();
            int terminal = electric.terminalIndexAt(blockState, context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
            if (terminal >= 0) {
                return this.onTerminal(context.method_8045(), new BlockWireEndpoint(pos, terminal), context.method_8041());
            }
        }
        return context.method_8045().method_35230(context.method_8037(), (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get()).map(be -> {
            class_2338 pos = context.method_8037();
            class_2680 state = context.method_8045().method_8320(context.method_8037());
            class_243 hitLocalPos = context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleY(state)), (class_2350.class_2351)class_2350.class_2351.field_11052);
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleX(state)), (class_2350.class_2351)class_2350.class_2351.field_11048);
            if (hitLocalPos.field_1351 >= 0.125 && hitLocalPos.field_1351 <= 0.1875) {
                int x = (int)(hitLocalPos.field_1352 * 16.0);
                int y = (int)(hitLocalPos.field_1350 * 16.0);
                if (!be.getSchematic().getLayer(CircuitSchematic.Layer.FRONT, x, y)) {
                    return class_1269.field_5814;
                }
                return this.onTerminal(context.method_8045(), new CircuitBoardEndpoint(pos, x, y), context.method_8041());
            }
            return class_1269.field_5811;
        }).orElse(class_1269.field_5811);
    }

    @Environment(value=EnvType.CLIENT)
    private static class_243 getAttachmentPoint() {
        class_239 hit = class_310.method_1551().field_1765;
        if (hit == null || hit.method_17783() != class_239.class_240.field_1331) {
            return null;
        }
        class_3966 entityHit = (class_3966)hit;
        return entityHit.method_17784();
    }

    public class_1269 useOnWire(class_1657 player, class_1799 stack, class_1268 hand, BaseWireEntity wireEntity) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        if (this.getMode(stack) != 1) {
            this.setMode(stack, 1);
        }
        if (player.method_37908().field_9236) {
            class_243 point = MultimeterItem.getAttachmentPoint();
            class_2487 data = this.getModeData(stack);
            data.method_10548("X", (float)point.field_1352);
            data.method_10548("Y", (float)point.field_1351);
            data.method_10548("Z", (float)point.field_1350);
            ModdedPackets.sendToServer(new MultimeterDataC2SPacket(point, wireEntity));
        }
        return class_1269.field_21466;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        super.method_7888(stack, level, entity, slotId, isSelected);
        class_2487 data = this.getModeData(stack);
        switch (this.getMode(stack)) {
            case 0: {
                float V;
                TransmissionLine line;
                OwnedFloatingNode node;
                class_243 negPos;
                class_1657 player;
                class_243 posPos;
                IWireEndpoint pos = WireEndpointType.deserialize(data.method_10562("Pos"));
                IWireEndpoint neg = WireEndpointType.deserialize(data.method_10562("Neg"));
                if (pos != null && ((posPos = pos.getExactPosition(level)).method_1022(entity.method_19538()) > 5.0 || !pos.isValid(level))) {
                    if (entity instanceof class_1657) {
                        player = (class_1657)entity;
                        player.method_7353((class_2561)Lang.translate("message.multimeter_disconnected", new Object[0]).style(class_124.field_1080).component(), true);
                    }
                    data.method_10551("Pos");
                }
                if (neg != null && ((negPos = neg.getExactPosition(level)).method_1022(entity.method_19538()) > 5.0 || !neg.isValid(level))) {
                    if (entity instanceof class_1657) {
                        player = (class_1657)entity;
                        player.method_7353((class_2561)Lang.translate("message.multimeter_disconnected", new Object[0]).style(class_124.field_1080).component(), true);
                    }
                    data.method_10551("Neg");
                }
                if (level.field_9236) break;
                boolean posRem = true;
                boolean negRem = true;
                if (pos != null && pos.type() == WireEndpointType.BLOCK && pos.isValid(level)) {
                    node = pos.getNode(level);
                    line = GlobalElectricNetworks.getWorldNetworks(level).findLineMiddle(node);
                    if (line != null) {
                        V = line.voltageFor(node);
                        data.method_10548("PosV", V);
                        posRem = false;
                    } else {
                        data.method_10548("PosV", node.getVoltage());
                    }
                }
                if (neg != null && neg.type() == WireEndpointType.BLOCK && neg.isValid(level)) {
                    node = neg.getNode(level);
                    line = GlobalElectricNetworks.getWorldNetworks(level).findLineMiddle(node);
                    if (line != null) {
                        V = line.voltageFor(node);
                        data.method_10548("NegV", V);
                        negRem = false;
                    } else {
                        data.method_10548("NegV", node.getVoltage());
                    }
                }
                if (!posRem || !negRem) break;
                data.method_10551("PosV");
                data.method_10551("NegV");
                break;
            }
            case 1: {
                class_243 point;
                TransmissionLinePart part;
                WireEntity wireEntity;
                ElectricWire wire;
                class_1297 genericEntity;
                if (!level.field_9236 && data.method_10545("UUID") && (genericEntity = ((class_3218)level).method_14190(data.method_25926("UUID"))) instanceof WireEntity && (wire = (wireEntity = (WireEntity)genericEntity).getWire()) instanceof TransmissionLinePart && (part = (TransmissionLinePart)wire).getLine() != null) {
                    int lineId = part.getLine().getId();
                    if (data.method_10550("LineId") != lineId) {
                        data.method_10569("LineId", lineId);
                    }
                }
                if (!data.method_10545("X") || !((point = new class_243((double)data.method_10583("X"), (double)data.method_10583("Y"), (double)data.method_10583("Z"))).method_1022(entity.method_19538()) > 5.0)) break;
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_7353((class_2561)Lang.translate("message.multimeter_disconnected", new Object[0]).style(class_124.field_1080).component(), true);
                }
                stack.method_7948().method_10551("ModeData");
            }
        }
    }

    public int getMode(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10545("Mode")) {
            return -1;
        }
        return stack.method_7948().method_10550("Mode");
    }

    public void setMode(class_1799 stack, int mode) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("Mode", mode);
        tag.method_10551("ModeData");
    }

    public class_2487 getModeData(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("ModeData")) {
            return tag.method_10562("ModeData");
        }
        class_2487 data = new class_2487();
        tag.method_10566("ModeData", (class_2520)data);
        return data;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        if (player.method_5715() && usedHand == class_1268.field_5808) {
            player.method_5998(usedHand).method_7980(null);
            player.method_7353((class_2561)Lang.translate("message.multimeter_disconnected", new Object[0]).style(class_124.field_1080).component(), true);
            return class_1271.method_22427((Object)player.method_5998(usedHand));
        }
        return super.method_7836(level, player, usedHand);
    }

    private class_1269 onTerminal(class_1937 level, IWireEndpoint endpoint, class_1799 stack) {
        IWireEndpoint current;
        class_2487 data;
        if (this.getMode(stack) != 0) {
            this.setMode(stack, 0);
        }
        if ((data = this.getModeData(stack)).method_10545("Pos") && endpoint.equals(current = WireEndpointType.deserialize(data.method_10562("Pos")))) {
            data.method_10551("Pos");
            return class_1269.field_5812;
        }
        if (data.method_10545("Neg") && endpoint.equals(current = WireEndpointType.deserialize(data.method_10562("Neg")))) {
            data.method_10551("Neg");
            return class_1269.field_5812;
        }
        if (data.method_10545("Pos") && data.method_10545("Neg")) {
            return class_1269.field_5811;
        }
        if (data.method_10545("Pos")) {
            data.method_10566("Neg", (class_2520)endpoint.serialize());
        } else {
            data.method_10566("Pos", (class_2520)endpoint.serialize());
        }
        return class_1269.field_21466;
    }

    public float getMeasurement(class_1937 level, class_1799 stack) {
        class_2487 data = this.getModeData(stack);
        return switch (this.getMode(stack)) {
            case 0 -> {
                CircuitBoardEndpoint e;
                IWireEndpoint pos = WireEndpointType.deserialize(data.method_10562("Pos"));
                IWireEndpoint neg = WireEndpointType.deserialize(data.method_10562("Neg"));
                if (pos == null || neg == null) {
                    yield 0.0f;
                }
                if (!pos.isValid(level) || !neg.isValid(level)) {
                    yield 0.0f;
                }
                float posV = 0.0f;
                float negV = 0.0f;
                if (data.method_10545("PosV")) {
                    posV = data.method_10583("PosV");
                } else {
                    IElectricNode v1;
                    if (pos instanceof CircuitBoardEndpoint) {
                        e = (CircuitBoardEndpoint)pos;
                        v1 = e.getGenericNode(level);
                    } else {
                        v1 = pos.getNode(level);
                    }
                    OwnedFloatingNode posNode = v1;
                    posV = posNode.getVoltage();
                }
                if (data.method_10545("NegV")) {
                    negV = data.method_10583("NegV");
                } else {
                    IElectricNode v2;
                    if (neg instanceof CircuitBoardEndpoint) {
                        e = (CircuitBoardEndpoint)neg;
                        v2 = e.getGenericNode(level);
                    } else {
                        v2 = neg.getNode(level);
                    }
                    OwnedFloatingNode negNode = v2;
                    negV = negNode.getVoltage();
                }
                yield posV - negV;
            }
            case 1 -> {
                int lineId = data.method_10550("LineId");
                yield ClientElectricNetwork.getWorldNetworks().tryGetCurrent(lineId);
            }
            default -> 0.0f;
        };
    }

    public class_2561 getText(class_1937 level, class_1657 user, class_1799 stack) {
        float measurement = this.getMeasurement(level, stack);
        return switch (this.getMode(stack)) {
            case 0 -> {
                LangBuilder voltage = Unit.VOLTAGE.formatWithPrefixes(measurement);
                if (measurement > 500.0f) {
                    voltage = Lang.text(">500 ").add(Unit.VOLTAGE.get());
                } else if (measurement < -500.0f) {
                    voltage = Lang.text("<-500 ").add(Unit.VOLTAGE.get());
                }
                yield Lang.translate("tooltip.multimeter.voltage", new Object[0]).add(voltage.style(class_124.field_1078)).style(class_124.field_1080).component();
            }
            case 1 -> {
                LangBuilder current = Unit.CURRENT.formatWithPrefixes(measurement);
                if (measurement > 50.0f) {
                    current = Lang.text(">50 ").add(Unit.CURRENT.get());
                } else if (measurement < -50.0f) {
                    current = Lang.text("<-50 ").add(Unit.CURRENT.get());
                }
                yield Lang.translate("tooltip.multimeter.current", new Object[0]).add(current.style(class_124.field_1054)).style(class_124.field_1080).component();
            }
            default -> null;
        };
    }

    public float getDial(class_1937 level, class_1799 stack) {
        float measurement = this.getMeasurement(level, stack);
        float value = Math.abs(switch (this.getMode(stack)) {
            case 0 -> measurement / 500.0f;
            case 1 -> measurement / 50.0f;
            default -> 0.0f;
        });
        if (value > 1.0f) {
            return 1.0f + level.field_9229.method_43057() * 0.125f;
        }
        return value;
    }

    @Override
    public void appendProperties(class_1799 stack, class_1657 player, List<class_2561> tooltip) {
        Voltage.max(500.0f, player, tooltip);
        Current.max(50.0f, player, tooltip);
    }
}

