/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.multimeter;

import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_811;
import org.joml.Quaternionf;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.wire.HangingWireRenderer;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItem;

@Environment(value=EnvType.CLIENT)
public class MultimeterItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final class_2960 TEXTURE = PowerGrid.texture("special/copper_wire");
    private static float mainPrevDial;
    private static float mainDial;
    private static float offPrevDial;
    private static float offDial;

    private static float getDialState(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        float pt = AnimationTickHolder.getPartialTicks();
        if (player.method_6047() == stack) {
            return class_3532.method_16439((float)pt, (float)mainPrevDial, (float)mainDial);
        }
        if (player.method_6079() == stack) {
            return class_3532.method_16439((float)pt, (float)offPrevDial, (float)offDial);
        }
        return 0.0f;
    }

    protected void render(class_1799 stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, class_811 transformType, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        renderer.render(model.getOriginalModel(), light);
        if (transformType.method_29998()) {
            double angle = -0.7853981633974483 + 1.5707963267948966 * (double)MultimeterItemRenderer.getDialState(stack);
            ms.method_49278(new Quaternionf().rotateZ((float)angle), 0.0f, -0.140625f, 0.0f);
        }
        renderer.render(ModdedPartialModels.MULTIMETER_NEEDLE.get(), light);
        ms.method_22909();
    }

    public static void clientTick(class_1937 level, class_1657 player) {
        class_1799 stack1 = player.method_6047();
        class_1792 class_17922 = stack1.method_7909();
        if (class_17922 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)class_17922;
            mainPrevDial = mainDial;
            mainDial = multimeter.getDial(level, stack1);
        } else {
            mainDial = 0.0f;
            mainPrevDial = 0.0f;
        }
        class_1799 stack2 = player.method_6079();
        class_1792 class_17923 = stack2.method_7909();
        if (class_17923 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)class_17923;
            offPrevDial = offDial;
            offDial = multimeter.getDial(level, stack2);
        } else {
            offDial = 0.0f;
            offPrevDial = 0.0f;
        }
    }

    public static void renderProbe(class_243 point, SuperRenderTypeBuffer buffer, class_4587 matrixStack, class_638 world, class_746 player, int color) {
        HangingWireRenderer.renderFromPositions(matrixStack, buffer.getBuffer(class_1921.method_23572((class_2960)TEXTURE)), player.method_30951(AnimationTickHolder.getPartialTicks()), point, (double)1.01f, (double)1.01f, 0.0625, (class_1920)world, color);
    }

    public static void render(SuperRenderTypeBuffer buffer, class_4587 matrixStack, class_638 world, class_746 player, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof MultimeterItem)) {
            return;
        }
        MultimeterItem multimeter = (MultimeterItem)class_17922;
        class_2487 data = multimeter.getModeData(stack);
        switch (multimeter.getMode(stack)) {
            case 0: {
                IWireEndpoint neg;
                IWireEndpoint pos = WireEndpointType.deserialize(data.method_10562("Pos"));
                if (pos != null && pos.isValid((class_1937)world)) {
                    MultimeterItemRenderer.renderProbe(pos.getExactPosition((class_1937)world), buffer, matrixStack, world, player, -49088);
                }
                if ((neg = WireEndpointType.deserialize(data.method_10562("Neg"))) == null || !neg.isValid((class_1937)world)) break;
                MultimeterItemRenderer.renderProbe(neg.getExactPosition((class_1937)world), buffer, matrixStack, world, player, -14671840);
                break;
            }
            case 1: {
                if (!data.method_10545("X")) break;
                class_243 pos = new class_243((double)data.method_10583("X"), (double)data.method_10583("Y"), (double)data.method_10583("Z"));
                MultimeterItemRenderer.renderProbe(pos, buffer, matrixStack, world, player, -14671840);
            }
        }
    }

    public static void render(SuperRenderTypeBuffer buffer, class_4587 matrixStack, class_638 world, class_746 player) {
        MultimeterItemRenderer.render(buffer, matrixStack, world, player, player.method_6047());
        MultimeterItemRenderer.render(buffer, matrixStack, world, player, player.method_6079());
    }

    public static class_2561 multimeterOverlayText(class_1657 player) {
        class_1799 stack2;
        class_1792 class_17922;
        class_2561 right = null;
        class_2561 left = null;
        class_1799 stack1 = player.method_6047();
        class_1792 class_17923 = stack1.method_7909();
        if (class_17923 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)class_17923;
            right = multimeter.getText(player.method_37908(), player, stack1);
        }
        if ((class_17922 = (stack2 = player.method_6079()).method_7909()) instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)class_17922;
            left = multimeter.getText(player.method_37908(), player, stack2);
        }
        if (right != null && left != null) {
            return class_2561.method_43473().method_10852(left).method_27693(" - ").method_10852(right);
        }
        if (right != null) {
            return right;
        }
        return left;
    }
}

