/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.base;

import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlockEntity;

public abstract class TunedBlockEntity
extends ElectricKineticBlockEntity {
    public LerpedFloat arm = LerpedFloat.linear().chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public TunedBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.arm.setValue(1.0);
    }

    public void initialize() {
        super.initialize();
        this.arm.forceNextSync();
        this.sendData();
    }

    private float getChaseSpeed() {
        return class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 60.0f * 0.05f), (float)0.0f, (float)1.0f);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            this.arm.chase((double)this.arm.getValue(), 0.0, LerpedFloat.Chaser.LINEAR);
            this.arm.forceNextSync();
            return;
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            double angle = this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed());
            double target = class_3532.method_15350((double)((double)this.arm.getValue() + angle / 315.0 * (double)Math.signum(speed)), (double)0.0, (double)1.0);
            this.arm.chase(target, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        } else {
            this.arm.chase(speed > 0.0f ? 1.0 : 0.0, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        }
        this.sendData();
    }

    public abstract void refreshParameters();

    public void tick() {
        super.tick();
        this.arm.tickChaser();
        if (!this.arm.settled()) {
            if (this.getSpeed() == 0.0f) {
                this.arm.updateChaseTarget(this.arm.getValue());
            }
            this.refreshParameters();
            this.method_5431();
        }
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            this.arm.forceNextSync();
        }
        compound.method_10566("Arm", (class_2520)this.arm.writeNBT());
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10566("Arm", (class_2520)this.arm.writeNBT());
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.arm.readNBT(compound.method_10562("Arm"), clientPacket);
        this.refreshParameters();
    }
}

