/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.clutch;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;

public class GeneratorClutchBlockEntity
extends KineticBlockEntity
implements RotorBehaviour.IForceSource {
    protected RotorBehaviour rotorBehaviour;
    private int currentRedstonePower = 0;
    public float load;
    private boolean recalculateStress = false;

    public GeneratorClutchBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.rotorBehaviour = new RotorBehaviour((SmartBlockEntity)this, ModdedConfigs.server().kinetics.generatorControls.generatorClutchInertia.getF());
        this.rotorBehaviour.forceSource(this);
        this.rotorBehaviour.setChangeCallback(this::assemblyChanged);
        behaviours.add(this.rotorBehaviour);
    }

    private void assemblyChanged() {
        this.recalculateStress = true;
    }

    public float torqueForStress() {
        return ModdedConfigs.server().kinetics.torqueForStress.getF();
    }

    @Override
    public float sourceForce(float velocity) {
        if (this.getTheoreticalSpeed() == 0.0f || this.isOverStressed()) {
            return 0.0f;
        }
        return (float)((double)(this.torqueForStress() * this.lastStressApplied / 30.0f) * Math.PI);
    }

    @Override
    public float forceSpeed() {
        return this.getTheoreticalSpeed();
    }

    @Override
    public void receiveUsedForce(float percent) {
        this.load = percent;
    }

    public void updateStrength(int receivedRedstonePower) {
        if (this.currentRedstonePower != receivedRedstonePower) {
            this.currentRedstonePower = receivedRedstonePower;
            this.recalculateStress = true;
        }
    }

    public void tick() {
        super.tick();
        if (this.recalculateStress) {
            if (this.hasNetwork() && (!this.field_11863.field_9236 || this.isVirtual())) {
                KineticNetwork network = this.getOrCreateNetwork();
                network.remove((KineticBlockEntity)this);
                network.add((KineticBlockEntity)this);
            }
            this.recalculateStress = false;
            this.notifyUpdate();
        }
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10567("Power", (byte)this.currentRedstonePower);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.currentRedstonePower = compound.method_10571("Power");
    }

    public float calculateStressApplied() {
        MutableFloat totalImpact = new MutableFloat(0.0f);
        this.rotorBehaviour.forEachSegment(segment -> totalImpact.add((Number)BlockStressValues.getImpact((class_2248)segment.blockEntity.method_11010().method_26204())));
        float couplingStrength = (float)(15 - this.currentRedstonePower) / 15.0f;
        this.lastStressApplied = totalImpact.getValue().floatValue() * couplingStrength;
        return this.lastStressApplied;
    }

    public void remove() {
        super.remove();
        this.rotorBehaviour.remove();
    }
}

