/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.rotor;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;

public class RotorRenderer
extends SafeBlockEntityRenderer<RotorBlockEntity> {
    public RotorRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(RotorBlockEntity rotor, float partialTicks, class_4587 matrixStack, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((class_1936)rotor.method_10997())) {
            return;
        }
        class_2680 state = rotor.method_11010();
        class_2350.class_2351 axis = ((AbstractRotorBlock)state.method_26204()).getAssemblyRotationAxis(state);
        SuperByteBuffer rotorModel = this.getModelForState(state);
        float rotorAngle = RotorRenderer.getRotorAngle(rotor, partialTicks);
        rotorModel.light(light);
        rotorModel.rotateCentered(rotorAngle, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis));
        rotorModel.renderInto(matrixStack, buffer.getBuffer(class_1921.method_23577()));
    }

    public static float getRotorAngle(SmartBlockEntity rotor, float partialTicks) {
        RotorBehaviour behaviour = (RotorBehaviour)rotor.getBehaviour(RotorBehaviour.TYPE);
        float rotorAngle = behaviour.getAngle() + behaviour.getAngularVelocity() * 0.3f * partialTicks;
        rotorAngle = rotorAngle / 180.0f * (float)Math.PI;
        return rotorAngle;
    }

    protected SuperByteBuffer getModelForState(class_2680 state) {
        return CachedBuffers.block((class_2680)state);
    }
}

