/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.kinetics.generator.housing.GeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.housing.VerticalGeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.winding.IWindingConnectable;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlockEntity;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WindingBlock
extends ElectricBlock
implements IBE<WindingBlockEntity>,
IAcceptConnector,
IWindingConnectable {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;
    public static final class_2758 PART = class_2758.method_11867((String)"part", (int)0, (int)2);
    public static final class_2746 ALONG_FIRST_AXIS = CustomProperties.ALONG_FIRST_AXIS;
    public static final class_2746 CASE_RIGHT = class_2746.method_11825((String)"right");
    public static final class_2746 CASE_LEFT = class_2746.method_11825((String)"left");
    private static final VoxelShaper HORIZONTAL_END_SHAPER = VoxelShaper.forDirectional((class_265)class_259.method_1084((class_265)WindingBlock.method_9541((double)2.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)16.0), (class_265)WindingBlock.method_9541((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)), (class_2350)class_2350.field_11035);
    private static final VoxelShaper VERTICAL_END_SHAPER = VoxelShaper.forDirectional((class_265)class_259.method_1084((class_265)WindingBlock.method_9541((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)16.0), (class_265)WindingBlock.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)), (class_2350)class_2350.field_11035);
    private static final VoxelShaper HORIZONTAL_MIDDLE_SHAPER = VoxelShaper.forAxis((class_265)WindingBlock.method_9541((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0), (class_2350.class_2351)class_2350.class_2351.field_11051);
    private static final VoxelShaper VERTICAL_MIDDLE_SHAPER = VoxelShaper.forAxis((class_265)WindingBlock.method_9541((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)16.0), (class_2350.class_2351)class_2350.class_2351.field_11051);

    public WindingBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        Integer part = (Integer)state.method_11654((class_2769)PART);
        if (part == 0 || part == 2) {
            class_2350 dir = class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state.method_11654(AXIS)), (class_2350.class_2352)(part == 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060));
            Boolean along = (Boolean)state.method_11654((class_2769)ALONG_FIRST_AXIS);
            VoxelShaper shaper = along != false ? VERTICAL_END_SHAPER : HORIZONTAL_END_SHAPER;
            return shaper.get(dir);
        }
        Boolean along = (Boolean)state.method_11654((class_2769)ALONG_FIRST_AXIS);
        VoxelShaper shaper = along != false ? VERTICAL_MIDDLE_SHAPER : HORIZONTAL_MIDDLE_SHAPER;
        return shaper.get((class_2350.class_2351)state.method_11654(AXIS));
    }

    private void walkForward(class_1936 world, class_2338 pos, class_2350.class_2351 axis, BiConsumer<class_2338, class_2680> callback) {
        boolean last = false;
        while (!last) {
            class_2680 state = world.method_8320(pos = pos.method_30513(axis, 1));
            if (!state.method_27852((class_2248)this)) {
                return;
            }
            if ((Integer)state.method_11654((class_2769)PART) == 2) {
                last = true;
            }
            callback.accept(pos, state);
        }
    }

    public void walkBackward(class_1936 world, class_2338 pos, class_2350.class_2351 axis, BiConsumer<class_2338, class_2680> callback) {
        boolean last = false;
        while (!last) {
            class_2680 state = world.method_8320(pos = pos.method_30513(axis, -1));
            if (!state.method_27852((class_2248)this)) {
                return;
            }
            if ((Integer)state.method_11654((class_2769)PART) == 0) {
                last = true;
            }
            callback.accept(pos, state);
        }
    }

    public void walk(class_1936 world, class_2338 pos, BiConsumer<class_2338, class_2680> callback) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)this)) {
            return;
        }
        callback.accept(pos, state);
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        switch ((Integer)state.method_11654((class_2769)PART)) {
            case 0: {
                this.walkForward(world, pos, axis, callback);
                break;
            }
            case 1: {
                this.walkForward(world, pos, axis, callback);
                this.walkBackward(world, pos, axis, callback);
                break;
            }
            case 2: {
                this.walkBackward(world, pos, axis, callback);
            }
        }
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        super.method_9556(world, player, pos, state, blockEntity, tool);
        if ((Integer)state.method_11654((class_2769)PART) != 1) {
            WindingBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)AllBlocks.SHAFT.asStack());
        }
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (world.method_8608()) {
            return;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        BiConsumer<class_2338, class_2680> breakBlock = (pos1, state1) -> {
            world.method_22352(pos1, true);
            if ((Integer)state1.method_11654((class_2769)PART) != 1) {
                world.method_8652(pos1, (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657(AXIS, (Comparable)this.getMagneticAxis((class_2680)state1)), 3);
            }
        };
        switch ((Integer)state.method_11654((class_2769)PART)) {
            case 0: {
                this.walkForward(world, pos, axis, breakBlock);
                break;
            }
            case 1: {
                this.walkForward(world, pos, axis, breakBlock);
                this.walkBackward(world, pos, axis, breakBlock);
                break;
            }
            case 2: {
                this.walkBackward(world, pos, axis, breakBlock);
            }
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AXIS, PART, ALONG_FIRST_AXIS, CASE_RIGHT, CASE_LEFT});
    }

    public static boolean canConnect(class_2680 thisState, boolean positive, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof WindingBlock) {
            WindingBlock windingBlock = (WindingBlock)class_22482;
            if (state.method_11654(AXIS) == thisState.method_11654(AXIS) && state.method_11654((class_2769)ALONG_FIRST_AXIS) == thisState.method_11654((class_2769)ALONG_FIRST_AXIS)) {
                return true;
            }
        } else {
            WindingBlock windingBlock;
            if (state.method_26204() instanceof GeneratorHousing) {
                windingBlock = (WindingBlock)thisState.method_26204();
                class_2350.class_2351 parallelAxis = windingBlock.getParallelCheckAxis(thisState);
                if (parallelAxis.method_10179()) {
                    class_2350 expectedFacing = class_2350.method_10169((class_2350.class_2351)parallelAxis, (class_2350.class_2352)(positive ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
                    return state.method_11654(GeneratorHousing.HORIZONTAL_FACING) == expectedFacing;
                }
                boolean expectUp = !positive;
                return (Boolean)state.method_11654((class_2769)GeneratorHousing.UP) == expectUp;
            }
            if (state.method_26204() instanceof VerticalGeneratorHousing) {
                windingBlock = (WindingBlock)thisState.method_26204();
                class_2350.class_2351 parallelAxis = windingBlock.getParallelCheckAxis(thisState);
                if (parallelAxis.method_10178()) {
                    return false;
                }
                class_2350 expectedFacing = class_2350.method_10169((class_2350.class_2351)parallelAxis, (class_2350.class_2352)(positive ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
                class_2350 housingFacing = (class_2350)state.method_11654(GeneratorHousing.HORIZONTAL_FACING);
                return housingFacing == expectedFacing || housingFacing.method_10160() == expectedFacing;
            }
        }
        return false;
    }

    @Override
    public boolean canConnect(class_2680 state, class_2350 side) {
        return this.getParallelCheckAxis(state) == side.method_10166();
    }

    @Override
    public class_2350 getOtherSide(class_2680 state, class_2350 sideIn) {
        return sideIn.method_10153();
    }

    public void updateCase(class_2680 state, class_1936 world, class_2338 pos) {
        class_2350.class_2351 axis = this.getParallelCheckAxis(state);
        class_2680 stateN = world.method_8320(pos.method_30513(axis, -1));
        boolean left = WindingBlock.canConnect(state, false, stateN);
        class_2680 stateP = world.method_8320(pos.method_30513(axis, 1));
        boolean right = WindingBlock.canConnect(state, true, stateP);
        class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)CASE_LEFT, (Comparable)Boolean.valueOf(left))).method_11657((class_2769)CASE_RIGHT, (Comparable)Boolean.valueOf(right));
        if (newState != state) {
            world.method_8652(pos, newState, 2);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        this.updateCase(state, (class_1936)world, pos);
        class_2338 dir = sourcePos.method_10059((class_2382)pos);
        if (class_2350.method_50026((int)dir.method_10263(), (int)dir.method_10264(), (int)dir.method_10260()).method_10166() == state.method_11654(AXIS)) {
            return;
        }
        this.withBlockEntityDo((class_1922)world, pos, be -> be.onNeighborChanged(sourcePos));
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int flags, int maxUpdateDepth) {
        super.method_9517(state, world, pos, flags, maxUpdateDepth);
        this.updateCase(state, world, pos);
    }

    @Nullable
    public class_2338 getMainBlockPos(class_1937 world, class_2338 pos) {
        if (!world.method_8477(pos)) {
            return null;
        }
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)this)) {
            return null;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        switch ((Integer)state.method_11654((class_2769)PART)) {
            case 0: {
                return pos;
            }
            case 1: 
            case 2: {
                do {
                    if (!world.method_8477(pos = pos.method_30513(axis, -1))) {
                        return null;
                    }
                    state = world.method_8320(pos);
                    if (state.method_27852((class_2248)this)) continue;
                    return null;
                } while ((Integer)state.method_11654((class_2769)PART) != 0);
                return pos;
            }
        }
        return null;
    }

    public Optional<WindingBlockEntity> getMainBlockEntity(class_1937 world, class_2338 pos) {
        class_2338 mainPos = this.getMainBlockPos(world, pos);
        if (mainPos != null) {
            return world.method_35230(mainPos, (class_2591)ModdedBlockEntities.WINDING.get());
        }
        return Optional.empty();
    }

    public class_2350.class_2351 getParallelCheckAxis(class_2680 state) {
        Boolean along = (Boolean)state.method_11654((class_2769)ALONG_FIRST_AXIS);
        return switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (along.booleanValue()) {
                    yield class_2350.class_2351.field_11051;
                }
                yield class_2350.class_2351.field_11052;
            }
            case class_2350.class_2351.field_11052 -> {
                if (along.booleanValue()) {
                    yield class_2350.class_2351.field_11048;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11051 -> along != false ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
        };
    }

    public class_2350.class_2351 getMagneticAxis(class_2680 state) {
        Boolean along = (Boolean)state.method_11654((class_2769)ALONG_FIRST_AXIS);
        return switch ((class_2350.class_2351)state.method_11654(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (along.booleanValue()) {
                    yield class_2350.class_2351.field_11052;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11052 -> {
                if (along.booleanValue()) {
                    yield class_2350.class_2351.field_11051;
                }
                yield class_2350.class_2351.field_11048;
            }
            case class_2350.class_2351.field_11051 -> along != false ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11048;
        };
    }

    public Class<WindingBlockEntity> getBlockEntityClass() {
        return WindingBlockEntity.class;
    }

    public class_2591<? extends WindingBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.WINDING.get();
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        Integer part = (Integer)state.method_11654((class_2769)PART);
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(AXIS);
        switch (part) {
            case 0: {
                if ((Integer)world.method_8320(pos.method_30513(axis, 1)).method_11654((class_2769)PART) == 1) break;
                return class_1269.field_5814;
            }
            case 1: {
                return class_1269.field_5814;
            }
            case 2: {
                if ((Integer)world.method_8320(pos.method_30513(axis, -1)).method_11654((class_2769)PART) == 1) break;
                return class_1269.field_5814;
            }
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_3218 serverWorld = (class_3218)world;
        if (player != null && !player.method_7337()) {
            class_2248.method_9609((class_2680)((class_2680)state.method_11657((class_2769)PART, (Comparable)Integer.valueOf(1))), (class_3218)serverWorld, (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)context.method_8041()).forEach(stack -> player.method_31548().method_7398(stack));
        }
        ((class_2680)state.method_11657((class_2769)PART, (Comparable)Integer.valueOf(1))).method_26180(serverWorld, pos, class_1799.field_8037, true);
        world.method_8501(pos, class_2246.field_10124.method_9564());
        class_2338 newPos = pos.method_30513(axis, 1 - part);
        world.method_8501(newPos, state);
        if ((Integer)state.method_11654((class_2769)PART) == 0) {
            this.withBlockEntityDo((class_1922)world, newPos, WindingBlockEntity::makeMain);
        }
        IWrenchable.playRemoveSound((class_1937)world, (class_2338)pos);
        return class_1269.field_5812;
    }

    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        if (!(world instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_3218 serverLevel = (class_3218)world;
        if (PlayerUtilities.cancelBreak(world, pos, player)) {
            return class_1269.field_5812;
        }
        this.walk((class_1936)world, pos, (pos1, state1) -> {
            if (player != null && !player.method_7337()) {
                class_2248.method_9609((class_2680)state1, (class_3218)serverLevel, (class_2338)pos1, (class_2586)world.method_8321(pos1), (class_1297)player, (class_1799)context.method_8041()).forEach(stack -> player.method_31548().method_7398(stack));
                if (pos.equals(pos1) && (Integer)state1.method_11654((class_2769)PART) != 1) {
                    player.method_31548().method_7398(AllBlocks.SHAFT.asStack());
                }
            }
            state1.method_26180(serverLevel, pos1, class_1799.field_8037, true);
            world.method_22352(pos1, false);
            if (!pos.equals(pos1) && (Integer)state1.method_11654((class_2769)PART) != 1) {
                world.method_8501(pos1, (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657(AXIS, (Comparable)this.getMagneticAxis((class_2680)state1)));
            }
        });
        IWrenchable.playRemoveSound((class_1937)world, (class_2338)pos);
        return class_1269.field_5812;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ModdedItems.COPPER_COIL.asStack();
    }

    @Override
    public boolean canConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 side) {
        return side.method_10166() == this.getMagneticAxis(state) && (Integer)state.method_11654((class_2769)PART) != 1;
    }

    @Override
    public boolean isPolarized() {
        return true;
    }
}

