/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.special.LRSeriesWire;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.kinetics.generator.winding.IWindingConnectable;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;

public class WindingBlockEntity
extends ElectricBlockEntity {
    private class_2338 ownerPosition;
    private Set<class_2338> parallelPositions;
    private WindingBlockEntity mainBE;
    private Set<WindingBlockEntity> collectedBEs;
    private float resistance = 0.1f;
    private int totalCoilCount = 0;
    private LRSeriesWire coilWire;
    private boolean rebuildParallels = false;

    public WindingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(40);
    }

    public static float coilConstant() {
        return ModdedConfigs.server().kinetics.generatorControls.windingCoilConstant.getF();
    }

    private boolean isMain() {
        return (Integer)this.method_11010().method_11654((class_2769)WindingBlock.PART) == 0;
    }

    public float fieldStrength() {
        WindingBlockEntity be = this.getSimElementHolder();
        if (be == null) {
            return 0.0f;
        }
        float I_sat = ModdedConfigs.server().kinetics.generatorControls.fieldSaturationCurrent.getF();
        float current = be.coilWire.current();
        float B = (current = (float)((double)I_sat * Math.tanh(1.5 * (double)current / (double)I_sat)) + current * 0.05f) * WindingBlockEntity.coilConstant();
        if (B == 0.0f) {
            return 0.001f;
        }
        if (Math.abs(B) < 0.001f) {
            return 0.001f * Math.signum(B);
        }
        return B;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (this.isMain()) {
            this.electricBehaviour = new ElectricBehaviour(this);
        } else {
            WindingBlock block = (WindingBlock)this.method_11010().method_26204();
            this.electricBehaviour = new ProxyElectricBehaviour(this, () -> block.getMainBlockPos(this.field_11863, this.field_11867));
        }
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        ThermalBehaviour thermal = ThermalBehaviour.fromConfig(this);
        if (thermal != null) {
            thermal.overheatCallback(() -> {
                assert (this.field_11863 != null);
                WindingBlock block = (WindingBlock)this.method_11010().method_26204();
                block.walk((class_1936)this.field_11863, this.field_11867, (pos1, state) -> this.field_11863.method_22352(pos1, false));
            });
        }
        return thermal;
    }

    private void checkParallelPosition(class_2338 thisPos, class_2350 side, boolean thisIsOwner) {
        assert (this.field_11863 != null);
        class_2338 checkPos = thisPos.method_10093(side);
        class_2680 checkState = this.field_11863.method_8320(checkPos);
        class_2680 thisState = this.field_11863.method_8320(thisPos);
        IWindingConnectable thisConnectible = (IWindingConnectable)thisState.method_26204();
        class_2248 class_22482 = checkState.method_26204();
        if (!(class_22482 instanceof IWindingConnectable)) {
            return;
        }
        IWindingConnectable checkConnectible = (IWindingConnectable)class_22482;
        if (!thisConnectible.canConnect(thisState, side)) {
            return;
        }
        if (!checkConnectible.canConnect(checkState, side.method_10153())) {
            return;
        }
        class_2248 class_22483 = checkState.method_26204();
        if (class_22483 instanceof WindingBlock) {
            WindingBlock windingBlock = (WindingBlock)class_22483;
            Optional<WindingBlockEntity> be = windingBlock.getMainBlockEntity(this.field_11863, checkPos);
            be.ifPresent(winding -> {
                if (checkState.method_11654(WindingBlock.AXIS) == thisState.method_11654(WindingBlock.AXIS)) {
                    if (thisIsOwner) {
                        this.addParallel((WindingBlockEntity)winding);
                    } else {
                        winding.addParallel(this);
                    }
                }
            });
        } else {
            class_2350 sideOut = checkConnectible.getOtherSide(checkState, side.method_10153());
            class_2680 checkState2 = this.field_11863.method_8320(checkPos = checkPos.method_10093(sideOut));
            class_2248 class_22484 = checkState2.method_26204();
            if (!(class_22484 instanceof WindingBlock)) {
                return;
            }
            WindingBlock windingBlock = (WindingBlock)class_22484;
            if (!windingBlock.canConnect(checkState2, sideOut.method_10153())) {
                return;
            }
            if (!checkConnectible.canConnect(checkState, sideOut)) {
                return;
            }
            Optional<WindingBlockEntity> be = windingBlock.getMainBlockEntity(this.field_11863, checkPos);
            be.ifPresent(winding -> {
                if (checkState2.method_11654(WindingBlock.AXIS) == thisState.method_11654(WindingBlock.AXIS)) {
                    if (thisIsOwner) {
                        this.addParallel((WindingBlockEntity)winding);
                    } else {
                        winding.addParallel(this);
                    }
                }
            });
        }
    }

    @NotNull
    private Collection<TransmissionLinePart> wires() {
        if (this.electricBehaviour == null) {
            return List.of();
        }
        return GlobalElectricNetworks.getWorldNetworks(this.field_11863).findConnectedWires(this.electricBehaviour);
    }

    private void rewire() {
        if (this.electricBehaviour != null) {
            Collection<TransmissionLinePart> wires = this.wires();
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                proxy.refreshEndpoints();
            }
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
    }

    public void addElectricBehaviour() {
        Collection<TransmissionLinePart> wires = this.wires();
        if (this.electricBehaviour == null) {
            this.electricBehaviour = new ElectricBehaviour(this);
            this.attachBehaviourLate(this.electricBehaviour);
        } else {
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                this.electricBehaviour = new ElectricBehaviour(this);
                this.electricBehaviour.inheritConnections(proxy);
                this.attachBehaviourLate(this.electricBehaviour);
            }
        }
        wires.forEach(TransmissionLinePart::refreshEndpointNodes);
    }

    public void removeElectricBehaviour() {
        Collection<TransmissionLinePart> wires = this.wires();
        ElectricBehaviour old = null;
        if (this.electricBehaviour != null && !(this.electricBehaviour instanceof ProxyElectricBehaviour)) {
            old = this.electricBehaviour;
            this.electricBehaviour = new ProxyElectricBehaviour(this, () -> this.ownerPosition);
            this.electricBehaviour.inheritConnections(old);
            old.pause();
            this.attachBehaviourLate(this.electricBehaviour);
            this.coilWire = null;
        }
        wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        if (old != null) {
            old.remove();
        }
    }

    private void collectWindingParts() {
        assert (this.field_11863 != null);
        WindingBlock block = (WindingBlock)this.method_11010().method_26204();
        class_2350.class_2351 parallelCheckAxis = block.getParallelCheckAxis(this.method_11010());
        if (this.isMain()) {
            this.mainBE = this;
            this.collectedBEs = new HashSet<WindingBlockEntity>();
            block.walk((class_1936)this.field_11863, this.field_11867, (pos1, state) -> {
                Optional opt = this.field_11863.method_35230(pos1, (class_2591)ModdedBlockEntities.WINDING.get());
                if (opt.isEmpty()) {
                    this.field_11863.method_22352(pos1, false);
                    return;
                }
                WindingBlockEntity be = (WindingBlockEntity)opt.get();
                this.collectedBEs.add(be);
                if (be.collectedBEs != null && be != this) {
                    if (be.ownerPosition != null) {
                        this.field_11863.method_35230(be.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::dissolveParallels);
                    } else if (be.parallelPositions != null) {
                        be.dissolveParallels();
                        be.electricBehaviour.breakConnections();
                        be.removeElectricBehaviour();
                    }
                    be.collectedBEs.forEach(other -> {
                        other.mainBE = this;
                        this.collectedBEs.add((WindingBlockEntity)other);
                    });
                    be.collectedBEs = null;
                    be.mainBE = this;
                    if (be.electricBehaviour != null) {
                        be.electricBehaviour.remove();
                        be.electricBehaviour = null;
                        be.removeBehaviour(ElectricBehaviour.TYPE);
                        be.coilWire = null;
                    }
                }
                if (!this.field_11863.field_9236 || this.isVirtual()) {
                    this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)parallelCheckAxis), false);
                    this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)parallelCheckAxis), false);
                }
            });
        } else {
            Optional<WindingBlockEntity> opt = block.getMainBlockEntity(this.field_11863, this.field_11867);
            if (opt.isEmpty()) {
                this.field_11863.method_22352(this.field_11867, false);
                return;
            }
            this.mainBE = opt.get();
            if (this.mainBE.collectedBEs != null && this.mainBE.collectedBEs.add(this)) {
                this.mainBE.electricBehaviour.breakConnections();
                this.mainBE.calculateElectricalParameters();
                this.mainBE.safeRebuildParallels();
            }
        }
    }

    public void makeMain() {
        assert (this.field_11863 != null);
        if (this.mainBE == null || this.mainBE == this) {
            return;
        }
        this.collectedBEs = this.mainBE.collectedBEs;
        this.collectedBEs.remove(this.mainBE);
        this.collectedBEs.forEach(be -> {
            be.mainBE = this;
        });
        this.calculateElectricalParameters();
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            this.safeRebuildParallels();
        }
    }

    private void addParallel(WindingBlockEntity otherMain) {
        assert (this.field_11863 != null);
        assert (this.isMain()) : "Only main block entities can keep track of parallel windings";
        assert (otherMain.isMain()) : "Parallel block entities must be the main entities of their windings";
        assert (!this.field_11863.field_9236 || this.isVirtual()) : "Parallel block entity collection can only occur on server";
        if (otherMain == this) {
            return;
        }
        if (this.ownerPosition != null) {
            Optional ownerWinding = this.field_11863.method_35230(this.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get());
            ownerWinding.ifPresentOrElse(owner -> owner.addParallel(otherMain), () -> {
                this.ownerPosition = null;
                this.calculateElectricalParameters();
            });
        }
        if (this.ownerPosition == null) {
            if (this.parallelPositions == null) {
                this.parallelPositions = new HashSet<class_2338>();
            }
            if (!this.parallelPositions.add(otherMain.method_11016())) {
                return;
            }
            if (otherMain.parallelPositions != null) {
                otherMain.parallelPositions.forEach(otherPos -> {
                    Optional be = this.field_11863.method_35230(otherPos, (class_2591)ModdedBlockEntities.WINDING.get());
                    be.ifPresent(winding -> {
                        winding.ownerPosition = this.field_11867;
                        this.parallelPositions.add((class_2338)otherPos);
                    });
                });
                otherMain.parallelPositions = null;
            } else if (otherMain.ownerPosition != null) {
                Optional be = this.field_11863.method_35230(otherMain.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get());
                be.ifPresent(this::addParallel);
            }
            otherMain.clearScheduledChange();
            otherMain.ownerPosition = this.field_11867;
            otherMain.removeElectricBehaviour();
            otherMain.sendData();
            this.sendData();
        }
    }

    public void initialize() {
        assert (this.field_11863 != null);
        if (this.collectedBEs == null) {
            this.collectWindingParts();
        }
        if (this.parallelPositions != null) {
            this.parallelPositions.forEach(pos -> this.field_11863.method_35230(pos, (class_2591)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::rewire));
        }
        if (this.isMain() && this.ownerPosition == null) {
            this.calculateElectricalParameters();
        }
        super.initialize();
    }

    public int getCoilCount() {
        if (this.collectedBEs == null) {
            this.collectWindingParts();
        }
        return this.collectedBEs.size();
    }

    private void clearScheduledChange() {
        this.rebuildParallels = false;
        if (this.collectedBEs == null) {
            return;
        }
        for (WindingBlockEntity be : this.collectedBEs) {
            be.rebuildParallels = false;
        }
    }

    private void calculateElectricalParameters() {
        assert (this.field_11863 != null);
        this.totalCoilCount = this.getCoilCount();
        if (this.ownerPosition != null && !this.ownerPosition.equals((Object)this.field_11867)) {
            this.field_11863.method_35230(this.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get()).ifPresent(WindingBlockEntity::calculateElectricalParameters);
            return;
        }
        this.resistance = (float)this.totalCoilCount * this.resistance();
        if (this.parallelPositions != null) {
            Iterator<class_2338> iter = this.parallelPositions.iterator();
            while (iter.hasNext()) {
                class_2338 windingPos = iter.next();
                Optional be = this.field_11863.method_35230(windingPos, (class_2591)ModdedBlockEntities.WINDING.get());
                if (be.isPresent()) {
                    WindingBlockEntity winding = (WindingBlockEntity)be.get();
                    this.totalCoilCount += winding.getCoilCount();
                    this.resistance += (float)winding.getCoilCount() * winding.resistance();
                    continue;
                }
                iter.remove();
            }
        }
        if (this.coilWire == null) {
            this.addElectricBehaviour();
        } else {
            this.coilWire.setLR(this.resistance * 0.01f, this.resistance);
        }
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.ownerPosition = null;
            this.parallelPositions = null;
            if (this.isMain()) {
                if (tag.method_10545("Owner")) {
                    int[] owner = tag.method_10561("Owner");
                    this.ownerPosition = new class_2338(owner[0], owner[1], owner[2]);
                    this.removeElectricBehaviour();
                } else if (this.mainBE != null) {
                    this.calculateElectricalParameters();
                }
                if (tag.method_10545("Parallel")) {
                    int[] data = tag.method_10561("Parallel");
                    this.parallelPositions = new HashSet<class_2338>();
                    for (int i = 0; i < data.length; i += 3) {
                        class_2338 pos = new class_2338(data[i], data[i + 1], data[i + 2]);
                        this.parallelPositions.add(pos);
                    }
                    if (this.mainBE != null) {
                        this.calculateElectricalParameters();
                    }
                }
            }
        }
        float current = tag.method_10583("Current");
        if (this.coilWire != null) {
            this.coilWire.valueChange(current, this.coilWire.current(), 5);
            this.coilWire.setCurrent(current);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.coilWire != null) {
            tag.method_10548("Current", this.coilWire.current());
        }
        if (clientPacket && this.isMain()) {
            if (this.ownerPosition != null) {
                tag.method_10539("Owner", new int[]{this.ownerPosition.method_10263(), this.ownerPosition.method_10264(), this.ownerPosition.method_10260()});
            }
            if (this.parallelPositions != null) {
                List data = this.parallelPositions.stream().flatMap(pos -> Stream.of(pos.method_10263(), pos.method_10264(), pos.method_10260())).toList();
                tag.method_10572("Parallel", data);
            }
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        if (this.ownerPosition == null) {
            builder.setTerminalCount(2);
            float R = Math.max(this.resistance, this.resistance());
            this.coilWire = new LRSeriesWire(R * 0.01f, R, builder.terminalNode(0), builder.terminalNode(1));
            builder.add(this.coilWire);
        }
    }

    private void rebuildParallels() {
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.ownerPosition != null) {
            PowerGrid.LOGGER.info("Non-owner winding is rebuilding parallels");
        }
        this.dissolveParallels();
        WindingBlock block = (WindingBlock)this.method_11010().method_26204();
        class_2350.class_2351 parallelCheckAxis = block.getParallelCheckAxis(this.method_11010());
        block.walk((class_1936)this.field_11863, this.field_11867, (pos1, state) -> {
            this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)parallelCheckAxis), true);
            this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)parallelCheckAxis), true);
        });
        if (this.parallelPositions != null) {
            HashSet<class_2338> checkedPositions = new HashSet<class_2338>();
            checkedPositions.add(this.field_11867);
            boolean shouldContinue = true;
            while (shouldContinue) {
                shouldContinue = false;
                List<class_2338> checkPositions = List.copyOf(this.parallelPositions);
                for (class_2338 position : checkPositions) {
                    if (!checkedPositions.add(position)) continue;
                    block.walk((class_1936)this.field_11863, position, (pos1, state) -> {
                        class_2350.class_2351 newCheckAxis = block.getParallelCheckAxis((class_2680)state);
                        this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)newCheckAxis), true);
                        this.checkParallelPosition((class_2338)pos1, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)newCheckAxis), true);
                    });
                    shouldContinue = true;
                }
            }
        }
        this.calculateElectricalParameters();
        this.sendData();
    }

    private void dissolveParallels() {
        assert (this.field_11863 != null);
        if (this.parallelPositions != null) {
            for (class_2338 parallelPos : this.parallelPositions) {
                Optional be = this.field_11863.method_35230(parallelPos, (class_2591)ModdedBlockEntities.WINDING.get());
                be.ifPresent(winding -> {
                    winding.ownerPosition = null;
                    winding.calculateElectricalParameters();
                });
            }
            this.parallelPositions = null;
        }
        if (this.ownerPosition != null) {
            PowerGrid.LOGGER.info("Non-owner winding is dissolving parallels");
        }
        this.ownerPosition = null;
        this.calculateElectricalParameters();
    }

    private void moveParallelOwnership(WindingBlockEntity newOwner, boolean withoutThis) {
        assert (this.field_11863 != null);
        if (newOwner == this) {
            return;
        }
        assert (this.ownerPosition == null && (this.field_11867.equals((Object)newOwner.ownerPosition) || newOwner.ownerPosition == null));
        this.parallelPositions.remove(newOwner.field_11867);
        if (!withoutThis) {
            this.parallelPositions.add(this.field_11867);
        }
        newOwner.parallelPositions = this.parallelPositions;
        this.parallelPositions = null;
        if (!withoutThis) {
            this.ownerPosition = newOwner.field_11867;
        }
        this.removeElectricBehaviour();
        newOwner.ownerPosition = null;
        newOwner.parallelPositions.forEach(bePos -> this.field_11863.method_35230(bePos, (class_2591)ModdedBlockEntities.WINDING.get()).ifPresent(be -> {
            be.ownerPosition = newOwner.field_11867;
        }));
        newOwner.calculateElectricalParameters();
    }

    public void onNeighborChanged(class_2338 neighborPos) {
        this.rebuildParallels = true;
    }

    private void safeRebuildParallels() {
        assert (this.field_11863 != null);
        if (this.mainBE == null) {
            return;
        }
        if (this.mainBE.parallelPositions != null) {
            this.mainBE.rebuildParallels();
        } else if (this.mainBE.ownerPosition != null) {
            Optional be = this.field_11863.method_35230(this.mainBE.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get());
            be.ifPresentOrElse(WindingBlockEntity::rebuildParallels, this.mainBE::rebuildParallels);
        } else {
            this.mainBE.rebuildParallels();
        }
    }

    private WindingBlockEntity getSimElementHolder() {
        assert (this.field_11863 != null);
        if (this.mainBE == null) {
            return null;
        }
        if (this.mainBE.ownerPosition != null) {
            if (this.mainBE.ownerPosition.equals((Object)this.field_11867)) {
                return null;
            }
            Optional opt = this.field_11863.method_35230(this.mainBE.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get());
            if (opt.isPresent()) {
                WindingBlockEntity be = (WindingBlockEntity)opt.get();
                return be.getSimElementHolder();
            }
        }
        if (this.mainBE.coilWire == null || this.mainBE.totalCoilCount == 0) {
            return null;
        }
        return this.mainBE;
    }

    public float windingCurrent() {
        WindingBlockEntity be = this.getSimElementHolder();
        if (be == null || !be.coilWire.isConverged()) {
            return 0.0f;
        }
        return be.coilWire.current();
    }

    @Override
    public void remove() {
        assert (this.field_11863 != null);
        if (this.mainBE != null) {
            for (TransmissionLinePart part : this.mainBE.wires()) {
                if (part.owner != null) {
                    part.owner.method_5768();
                    continue;
                }
                part.remove();
            }
            this.mainBE.electricBehaviour.breakConnections();
        }
        if (this.mainBE == this) {
            if (this.parallelPositions != null) {
                WindingBlockEntity newOwner = null;
                Iterator<class_2338> iter = this.parallelPositions.iterator();
                while (newOwner == null && iter.hasNext()) {
                    class_2338 bePos = iter.next();
                    Optional be = this.field_11863.method_35230(bePos, (class_2591)ModdedBlockEntities.WINDING.get());
                    if (!be.isPresent()) continue;
                    newOwner = (WindingBlockEntity)be.get();
                }
                if (newOwner != null) {
                    this.moveParallelOwnership(newOwner, true);
                }
            } else if (this.ownerPosition != null) {
                Optional be = this.field_11863.method_35230(this.ownerPosition, (class_2591)ModdedBlockEntities.WINDING.get());
                be.ifPresentOrElse(WindingBlockEntity::rebuildParallels, this::rebuildParallels);
            }
        } else if (this.mainBE != null) {
            this.mainBE.collectedBEs.remove(this);
            this.mainBE.calculateElectricalParameters();
            this.mainBE.safeRebuildParallels();
        }
        super.remove();
    }

    public void tick() {
        if (this.rebuildParallels) {
            this.safeRebuildParallels();
            this.rebuildParallels = false;
        }
        float current = this.windingCurrent();
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyTickPower(current * current * this.resistance());
        }
        this.method_5431();
        super.tick();
    }
}

