/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.motor;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.motor.ConstantSpeedMotorBlock;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlock;
import org.patryk3211.powergrid.kinetics.motor.SpeedScrollValueBehaviour;
import org.patryk3211.powergrid.mixin.KineticBlockEntityAccessor;
import org.patryk3211.powergrid.utility.Lang;

public class ConstantSpeedMotorBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricEntity {
    public static final int AVERAGING_TICKS = 5;
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;
    private SpeedScrollValueBehaviour scrollValue;
    private ElectricWire coil;
    private float generatedSU = 0.0f;
    private float avgSpeed;

    public ConstantSpeedMotorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(5);
    }

    public float torque() {
        return (float)(BlockStressValues.getCapacity((class_2248)this.method_11010().method_26204()) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        float maxPower = 256.0f * this.torque() / 60.0f;
        float baseFactor = ThermalBehaviour.dissipationFactor(maxPower, 150.0f);
        this.thermalBehaviour = ThermalBehaviour.simple((SmartBlockEntity)this, 3.5f, baseFactor);
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
        Integer max = (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        this.scrollValue = new SpeedScrollValueBehaviour((class_2561)Lang.translateDirect("devices.motor.speed", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new Box());
        this.scrollValue.between(0, max);
        this.scrollValue.value = 16;
        this.scrollValue.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.scrollValue);
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSU = compound.method_10583("GeneratedStress");
        this.updateGeneratedRotation();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("GeneratedStress", this.generatedSU);
    }

    public void lazyTick() {
        assert (this.field_11863 != null);
        super.lazyTick();
        int newSpeed = (int)(this.avgSpeed / 5.0f);
        this.avgSpeed = 0.0f;
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            if (newSpeed > 256) {
                newSpeed = 256;
            }
            if (newSpeed < -256) {
                newSpeed = -256;
            }
            if ((float)(newSpeed *= (int)BlockStressValues.getCapacity((class_2248)this.method_11010().method_26204())) != this.generatedSU) {
                this.generatedSU = newSpeed;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tick() {
        assert (this.field_11863 != null);
        this.applyPower(this.coil);
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            float speedFromPower = this.coil.power() / this.torque() * 60.0f;
            this.avgSpeed += speedFromPower * Math.signum(this.coil.current());
        }
        super.tick();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        super.applyNewSpeed(prevSpeed, speed);
        if (Math.signum(prevSpeed) == Math.signum(speed)) {
            for (KineticBlockEntity entry : this.getOrCreateNetwork().members.keySet()) {
                ((KineticBlockEntityAccessor)entry).setFlickerTally(Math.max(entry.getFlickerScore() - 5, 0));
            }
        }
    }

    public float getGeneratedSpeed() {
        if (Math.abs(this.generatedSU) < 64.0f) {
            return 0.0f;
        }
        return ConstantSpeedMotorBlockEntity.convertToDirection((float)(this.scrollValue.getValue() * (this.generatedSU < 0.0f ? -1 : 1)), (class_2350)((class_2350)this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING)));
    }

    public float calculateAddedStressCapacity() {
        if (Math.abs(this.generatedSU) < 64.0f) {
            return 0.0f;
        }
        return Math.abs(this.generatedSU) / (float)this.scrollValue.getValue();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.coil = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    public static class Box
    extends CenteredSideValueBoxTransform {
        public Box() {
            super((state, dir) -> {
                class_2350 facing = (class_2350)state.method_11654((class_2769)ConstantSpeedMotorBlock.FACING);
                if (facing.method_10166() == class_2350.class_2351.field_11052) {
                    return dir.method_10166() == class_2350.class_2351.field_11051;
                }
                return dir == class_2350.field_11036;
            });
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }
    }
}

