/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.motor;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.DirectionalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlock;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlockEntity;

public class ElectricMotorBlock
extends ElectricKineticBlock
implements IBE<ElectricMotorBlockEntity>,
IHaveElectricProperties,
IAcceptCord {
    public static final class_2753 FACING = class_2741.field_12525;
    private static final class_265 NORTH_SHAPE = ElectricMotorBlock.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    private static final TerminalBoundingBox[] NORTH_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 2.5, 11.5, 6.5, 4.5, 13.5, 9.5).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 11.5, 11.5, 6.5, 13.5, 13.5, 9.5).withColor(3899647)};

    public ElectricMotorBlock(class_4970.class_2251 properties) {
        super(properties);
        this.setTerminalCollection(DirectionalElectricBlock.directionalNorthTerminals((class_2248)this, NORTH_TERMINALS, NORTH_SHAPE));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2350 getPreferredFacing(class_1750 context) {
        class_2350 prefferedSide = null;
        for (class_2350 side : Iterate.directions) {
            class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10093(side));
            if (!(blockState.method_26204() instanceof IRotate) || !((IRotate)blockState.method_26204()).hasShaftTowards((class_4538)context.method_8045(), context.method_8037().method_10093(side), blockState, side.method_10153())) continue;
            if (prefferedSide != null && prefferedSide.method_10166() != side.method_10166()) {
                prefferedSide = null;
                break;
            }
            prefferedSide = side;
        }
        return prefferedSide == null ? null : prefferedSide.method_10153();
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 preferred = this.getPreferredFacing(context);
        if (preferred == null || context.method_8036() != null && context.method_8036().method_5715()) {
            class_2350 nearestLookingDirection = context.method_7715();
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)(context.method_8036() != null && context.method_8036().method_5715() ? nearestLookingDirection : nearestLookingDirection.method_10153()));
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)preferred.method_10153());
    }

    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == state.method_11654((class_2769)FACING);
    }

    public Class<ElectricMotorBlockEntity> getBlockEntityClass() {
        return ElectricMotorBlockEntity.class;
    }

    public class_2591<? extends ElectricMotorBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.ELECTRIC_MOTOR.get();
    }

    @Override
    public void appendProperties(class_1799 stack, class_1657 player, List<class_2561> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        double torque = BlockStressValues.getCapacity((class_2248)this) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF();
        double maxPower = 256.0 * torque / 60.0;
        Voltage.max((int)Math.sqrt(maxPower * (double)this.resistance()), player, tooltip);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public boolean renderPlug() {
        return true;
    }
}

