/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.motor;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlock;
import org.patryk3211.powergrid.mixin.KineticBlockEntityAccessor;

public class ElectricMotorBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricEntity {
    public static final int AVERAGING_TICKS = 5;
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;
    private ElectricWire coil;
    private float generatedSpeed = 0.0f;
    private float avgSpeed;

    public ElectricMotorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(5);
    }

    public float torque() {
        return (float)(BlockStressValues.getCapacity((class_2248)this.method_11010().method_26204()) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        float maxPower = 256.0f * this.torque() / 60.0f;
        float baseFactor = ThermalBehaviour.dissipationFactor(maxPower, 150.0f);
        this.thermalBehaviour = ThermalBehaviour.simple((SmartBlockEntity)this, 3.5f, baseFactor);
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSpeed = compound.method_10583("GeneratedSpeed");
        this.updateGeneratedRotation();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("GeneratedSpeed", this.generatedSpeed);
    }

    public void lazyTick() {
        assert (this.field_11863 != null);
        super.lazyTick();
        int newSpeed = (int)(this.avgSpeed / 5.0f);
        this.avgSpeed = 0.0f;
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            if (newSpeed > 256) {
                newSpeed = 256;
            }
            if (newSpeed < -256) {
                newSpeed = -256;
            }
            if ((float)newSpeed != this.generatedSpeed) {
                this.generatedSpeed = newSpeed;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tick() {
        assert (this.field_11863 != null);
        this.applyPower(this.coil);
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            float speedFromPower = this.coil.power() / this.torque() * 60.0f;
            this.avgSpeed += speedFromPower * Math.signum(this.coil.current());
        }
        super.tick();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        super.applyNewSpeed(prevSpeed, speed);
        if (Math.signum(prevSpeed) == Math.signum(speed)) {
            for (KineticBlockEntity entry : this.getOrCreateNetwork().members.keySet()) {
                ((KineticBlockEntityAccessor)entry).setFlickerTally(Math.max(entry.getFlickerScore() - 5, 0));
            }
        }
    }

    public float getGeneratedSpeed() {
        return ElectricMotorBlockEntity.convertToDirection((float)this.generatedSpeed, (class_2350)((class_2350)this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING)));
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.coil = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }
}

