/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.rheostat;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.resistor.ResistorValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.base.TunedBlockEntity;
import org.patryk3211.powergrid.kinetics.rheostat.RheostatBlock;
import org.patryk3211.powergrid.utility.Lang;

public class RheostatBlockEntity
extends TunedBlockEntity
implements IHaveGoggleInformation {
    protected ResistorValueBehaviour value;
    protected ElectricWire half1;
    protected ElectricWire half2;

    public RheostatBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.value = new ResistorValueBehaviour((class_2561)Lang.translateDirect("devices.resistor.resistance", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new RheostatBox(), -2, 18);
        this.value.setValue(0);
        this.value.withCallback($ -> this.refreshParameters());
        behaviours.add((BlockEntityBehaviour)this.value);
        super.addBehaviours(behaviours);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig((SmartBlockEntity)this);
    }

    public float getRatio() {
        if (this.arm == null) {
            return 0.01f;
        }
        return this.arm.getValue() * 0.98f + 0.01f;
    }

    @Override
    public float resistance() {
        return this.value.getResistance();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(3);
        float ratio = this.getRatio();
        this.half1 = builder.connect((1.0f - ratio) * this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
        this.half2 = builder.connect(ratio * this.resistance(), builder.terminalNode(1), builder.terminalNode(2));
    }

    @Override
    public void refreshParameters() {
        float ratio = this.getRatio();
        this.half1.setResistance((1.0f - ratio) * this.resistance());
        this.half2.setResistance(ratio * this.resistance());
    }

    @Override
    public void tick() {
        this.applyPower(this.half1);
        this.applyPower(this.half2);
        super.tick();
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!isPlayerSneaking) {
            return false;
        }
        Lang.builder().translate("gui.rheostat.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.rheostat.ratio", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float ratio = this.getRatio();
        LangBuilder ratioText = Lang.number(1.0f - ratio).add(class_2561.method_43470((String)" : ")).add(Lang.number(ratio));
        ratioText.style(class_124.field_1075).forGoggles(tooltip, 1);
        return true;
    }

    public static class RheostatBox
    extends CenteredSideValueBoxTransform {
        public RheostatBox() {
            super((state, dir) -> dir != state.method_11654((class_2769)RheostatBlock.HORIZONTAL_FACING) && dir.method_10166() != class_2350.class_2351.field_11052);
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)6.0, (double)13.5);
        }
    }
}

