/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.servo;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.motor.ElectricMotorBlock;
import org.patryk3211.powergrid.mixin.KineticBlockEntityAccessor;

public class ServoBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricEntity {
    public static final float MAX_SPEED = 32.0f;
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;
    private float generatedSpeed;
    private float currentAngle;
    private float maxSpeed;
    private float currentTarget;
    private ElectricWire coil;
    private ElectricWire control;
    private float avgSpeed;
    private float avgTarget;

    public ServoBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(5);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        float maxPower = 32.0f * this.torque() / 60.0f;
        float baseFactor = ThermalBehaviour.dissipationFactor(maxPower, 150.0f);
        this.thermalBehaviour = ThermalBehaviour.simple((SmartBlockEntity)this, 3.5f, baseFactor);
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    public float torque() {
        return (float)(BlockStressValues.getCapacity((class_2248)this.method_11010().method_26204()) * (double)ModdedConfigs.server().kinetics.torqueForStress.getF());
    }

    public void lazyTick() {
        float newTarget;
        super.lazyTick();
        if (this.field_11863.field_9236) {
            return;
        }
        this.currentTarget = newTarget = class_3532.method_15363((float)(this.avgTarget / 5.0f / 5.0f * 360.0f), (float)-360.0f, (float)360.0f);
        this.avgTarget = 0.0f;
        this.maxSpeed = Math.min(this.avgSpeed / 5.0f, 32.0f);
        this.avgSpeed = 0.0f;
        if (this.maxSpeed == 0.0f && this.generatedSpeed != 0.0f) {
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
            this.notifyUpdate();
        }
    }

    public void tick() {
        this.applyPower(this.coil);
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            float speedFromPower = this.coil.power() / this.torque() * 60.0f;
            this.avgSpeed += speedFromPower;
            this.avgTarget += this.control.potentialDifference();
        }
        super.tick();
        if (!this.field_11863.field_9236 || this.isVirtual()) {
            float dT;
            float speed;
            float rotation = (this.currentTarget - this.currentAngle) / 360.0f;
            if (Math.abs(rotation) < 0.01f) {
                rotation = 0.0f;
            }
            if ((speed = class_3532.method_15363((float)(rotation / (dT = 0.05f) * 60.0f), (float)(-this.maxSpeed), (float)this.maxSpeed)) != this.generatedSpeed) {
                this.generatedSpeed = speed;
                this.updateGeneratedRotation();
                this.notifyUpdate();
            }
            if (this.generatedSpeed != 0.0f) {
                this.coil.setResistance(this.resistance("on"));
            } else {
                this.coil.setResistance(this.resistance("idle"));
            }
            this.currentAngle += this.generatedSpeed / 60.0f * dT * 360.0f;
        }
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(3);
        this.coil = builder.connect(this.resistance("idle"), builder.terminalNode(0), builder.terminalNode(1));
        this.control = builder.connect(1000.0f, builder.terminalNode(2), builder.terminalNode(1));
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSpeed = compound.method_10583("GeneratedSpeed");
        this.currentAngle = compound.method_10583("Angle");
        if (this.generatedSpeed != 0.0f) {
            this.coil.setResistance(this.resistance("on"));
        } else {
            this.coil.setResistance(this.resistance("idle"));
        }
        this.updateGeneratedRotation();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("GeneratedSpeed", this.generatedSpeed);
        compound.method_10548("Angle", this.currentAngle);
    }

    public float getGeneratedSpeed() {
        return ServoBlockEntity.convertToDirection((float)this.generatedSpeed, (class_2350)((class_2350)this.method_11010().method_11654((class_2769)ElectricMotorBlock.FACING)));
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        super.applyNewSpeed(prevSpeed, speed);
        if (Math.signum(prevSpeed) == Math.signum(speed)) {
            for (KineticBlockEntity entry : this.getOrCreateNetwork().members.keySet()) {
                ((KineticBlockEntityAccessor)entry).setFlickerTally(Math.max(entry.getFlickerScore() - 5, 0));
            }
        }
    }
}

