/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.IMultiScreenHandlerFactory;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.network.SimplePacket;

public class SaveSchematicC2SPacket
implements SimplePacket {
    private final class_2338 pos;
    private class_2487 nbt;
    @Nullable
    private String name;
    private boolean load;

    public <T extends class_2586> SaveSchematicC2SPacket(T be, boolean load) {
        this.pos = be.method_11016();
        this.nbt = null;
        this.load = load;
    }

    public <T extends class_2586> SaveSchematicC2SPacket(T be, @Nullable String name, CircuitSchematic schematic) {
        this.pos = be.method_11016();
        this.nbt = schematic.serializeNbt();
        this.name = name;
    }

    public SaveSchematicC2SPacket(class_2540 buf) {
        this.pos = buf.method_10811();
        if (buf.readBoolean()) {
            this.nbt = buf.method_10798();
            if (buf.readBoolean()) {
                this.name = buf.method_19772();
            }
        } else {
            this.load = buf.readBoolean();
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10807(this.pos);
        buf.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            buf.method_10794(this.nbt);
            buf.writeBoolean(this.name != null);
            if (this.name != null) {
                buf.method_10814(this.name);
            }
        } else {
            buf.writeBoolean(this.load);
        }
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            class_1937 world = ctx.getPlayer().method_37908();
            class_2586 be = world.method_8321(this.pos);
            if (be instanceof CircuitDesignTableBlockEntity) {
                CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)be;
                if (this.nbt != null) {
                    table.getSchematic().deserializeNbt(this.nbt);
                    table.setSchematicName(this.name);
                    table.notifyUpdate();
                    IMultiScreenHandlerFactory.openScreen((class_3222)ctx.getPlayer(), table, arg_0 -> ((CircuitDesignTableBlockEntity)table).sendToMenu(arg_0), 0);
                } else if (this.load) {
                    table.readFromItem();
                } else {
                    table.writeToItem(ctx.getPlayer().method_7337());
                }
            } else if (be instanceof ISchematicHolder) {
                ISchematicHolder holder = (ISchematicHolder)be;
                if (ctx.getPlayer().method_7337() && this.nbt != null) {
                    holder.setSchematic(CircuitSchematic.fromNbt(this.nbt));
                }
            }
        });
    }
}

