/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.joml.Math;
import org.joml.Vector3f;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.particles.ZapParticleData;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class ZapProjectileS2CPacket
implements SimplePacket {
    private final Type type;
    private Vector3f pos;
    private class_2350 dir;
    private int targetEntity;
    private List<Integer> affectedEntities;

    public ZapProjectileS2CPacket(class_3965 hit) {
        this.type = Type.BLOCK_HIT;
        this.pos = hit.method_17784().method_46409();
        this.dir = hit.method_17780();
    }

    public ZapProjectileS2CPacket(class_1297 target, Collection<class_1297> affected) {
        this.type = Type.ENTITY_HIT;
        this.targetEntity = target.method_5628();
        this.affectedEntities = affected.stream().map(class_1297::method_5628).collect(Collectors.toList());
    }

    public ZapProjectileS2CPacket(class_2540 buf) {
        this.type = (Type)buf.method_10818(Type.class);
        switch (this.type.ordinal()) {
            case 0: {
                this.pos = buf.method_49069();
                this.dir = (class_2350)buf.method_10818(class_2350.class);
                break;
            }
            case 1: {
                this.targetEntity = buf.readInt();
                int len = buf.readInt();
                this.affectedEntities = new ArrayList<Integer>();
                for (int i = 0; i < len; ++i) {
                    this.affectedEntities.add(buf.readInt());
                }
                break;
            }
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10817((Enum)this.type);
        switch (this.type.ordinal()) {
            case 0: {
                buf.method_49068(this.pos);
                buf.method_10817((Enum)this.dir);
                break;
            }
            case 1: {
                buf.writeInt(this.targetEntity);
                buf.writeInt(this.affectedEntities.size());
                for (Integer i : this.affectedEntities) {
                    buf.writeInt(i.intValue());
                }
                break;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            class_1937 world = ClientSideAccess.world();
            switch (this.type.ordinal()) {
                case 0: {
                    SparkParticleData.explodeParticles(world, this.pos.x, this.pos.y, this.pos.z, this.dir, 20);
                    break;
                }
                case 1: {
                    class_1297 target = world.method_8469(this.targetEntity);
                    if (target == null) {
                        return;
                    }
                    class_243 origin = target.method_5829().method_1005();
                    for (Integer id : this.affectedEntities) {
                        class_1297 entity = world.method_8469(id.intValue());
                        if (entity == null) continue;
                        class_243 end = entity.method_5829().method_1005();
                        world.method_17452((class_2394)new ZapParticleData((float)end.field_1352, (float)end.field_1351, (float)end.field_1350, true), true, origin.field_1352, origin.field_1351, origin.field_1350, 0.0, 0.0, 0.0);
                        class_5819 r = world.field_9229;
                        for (int i = 0; i < 10; ++i) {
                            float pos = r.method_43057();
                            double x = Math.lerp((double)pos, (double)origin.field_1352, (double)end.field_1352);
                            double y = Math.lerp((double)pos, (double)origin.field_1351, (double)end.field_1351);
                            double z = Math.lerp((double)pos, (double)origin.field_1350, (double)end.field_1350);
                            world.method_8406((class_2394)SparkParticleData.INSTANCE, x, y, z, (double)(r.method_43057() - 0.5f), (double)(r.method_43057() - 0.5f), (double)(r.method_43057() - 0.5f));
                        }
                    }
                    break;
                }
            }
        });
    }

    private static enum Type {
        BLOCK_HIT,
        ENTITY_HIT;

    }
}

