/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.base;

import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.PonderElementBase;
import net.minecraft.class_1937;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;

public class VoltageSource
extends PonderElementBase {
    private final IWireEndpoint target;
    private final float voltage;
    private VoltageSourceCoupling source;

    public VoltageSource(IWireEndpoint target, float voltage) {
        this.target = target;
        this.voltage = voltage;
    }

    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.source == null) {
            OwnedFloatingNode node = this.target.getNode((class_1937)scene.getWorld());
            if (node.getNetwork() == null) {
                WorldNetworks global = GlobalElectricNetworks.getWorldNetworks((class_1937)scene.getWorld());
                this.target.joinNetwork((class_1937)scene.getWorld(), global.newNetwork());
            }
            ElectricalNetwork network = node.getNetwork();
            this.source = new VoltageSourceCoupling(node, null, 0.0f, this.voltage);
            network.addNode((INode)this.source);
        }
    }

    public void reset(PonderScene scene) {
        if (this.source != null) {
            this.source.getNetwork().removeNode(this.source);
            this.source = null;
        }
    }

    public void setValue(float value) {
        if (this.source != null) {
            this.source.setVoltage(value);
        }
    }
}

