/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.scenes;

import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SocketEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SplitCordEndpoint;
import org.patryk3211.powergrid.ponder.base.ElectricInstructions;
import org.patryk3211.powergrid.ponder.base.PowerGridSceneBuilder;

public class WireScenes {
    public static void simple(SceneBuilder scene, SceneBuildingUtil util) {
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("wire_simple", "Transferring electricity using wires");
        scene.configureBasePlate(0, 0, 7);
        class_2338 sourcePos = util.grid().at(0, 1, 0);
        class_2338 lightPos = util.grid().at(6, 1, 3);
        electric.connectInvisible(util.grid().at(0, 1, 2), 0, sourcePos, 0);
        electric.connectInvisible(util.grid().at(0, 1, 4), 0, sourcePos, 1);
        electric.setSource(sourcePos, 62.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 5, 1, 4), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(lightPos), class_2350.field_11033);
        scene.idle(5);
        electric.connect(util.grid().at(0, 1, 4), 0, util.grid().at(5, 1, 4), 0);
        scene.idle(5);
        electric.connect(util.grid().at(5, 1, 4), 0, lightPos, 1);
        scene.idle(5);
        electric.connect(util.grid().at(5, 1, 2), 0, lightPos, 0);
        scene.idle(5);
        electric.connect(util.grid().at(0, 1, 2), 0, util.grid().at(5, 1, 2), 0);
        scene.idle(10);
        scene.world().modifyBlock(lightPos, state -> (class_2680)state.method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(2)), false);
        scene.overlay().showText(80).text("Wires are used to transfer electricity between terminals of electric devices").attachKeyFrame().pointAt(util.vector().of(3.0, 1.3, 2.5)).placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
        electric.unload();
    }

    public static void voltageDrop(SceneBuilder scene, SceneBuildingUtil util) {
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("wire_voltage_drop", "Transfer losses");
        scene.configureBasePlate(0, 0, 7);
        class_2338 sourcePos = util.grid().at(0, 1, 0);
        electric.connectInvisible(util.grid().at(0, 1, 2), 0, sourcePos, 0);
        electric.connectInvisible(util.grid().at(0, 1, 4), 0, sourcePos, 1);
        electric.setSource(sourcePos, 20.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 6, 1, 4), class_2350.field_11033);
        scene.idle(5);
        electric.connect(util.grid().at(0, 1, 2), 0, util.grid().at(5, 1, 2), 0, 5.0f);
        electric.connect(util.grid().at(0, 1, 4), 0, util.grid().at(5, 1, 4), 0, 5.0f);
        electric.connect(util.grid().at(5, 1, 2), 0, util.grid().at(6, 1, 3), 1);
        electric.connect(util.grid().at(5, 1, 4), 0, util.grid().at(6, 1, 3), 0);
        electric.connect(util.grid().at(5, 1, 2), 0, util.grid().at(5, 1, 3), 0);
        electric.connect(util.grid().at(5, 1, 4), 0, util.grid().at(5, 1, 3), 1);
        electric.connect(util.grid().at(0, 1, 2), 0, util.grid().at(1, 1, 3), 0);
        electric.connect(util.grid().at(0, 1, 4), 0, util.grid().at(1, 1, 3), 1);
        scene.idle(10);
        scene.overlay().showText(80).text("Every wire has a resistance, the longer the wire, the more resistance it has").attachKeyFrame().placeNearTarget();
        scene.idle(90);
        electric.tickFor(10);
        scene.overlay().showText(80).text("This causes a voltage drop to occur when current is flowing").pointAt(util.vector().blockSurface(util.grid().at(5, 1, 3), class_2350.field_11039)).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(60).text("Lost power is turned into heat").attachKeyFrame().placeNearTarget();
        scene.idle(70);
        scene.overlay().showText(80).text("If too much power is drawn, the wires can overheat and break").placeNearTarget();
        scene.idle(20);
        for (int i = 0; i < 10; ++i) {
            scene.effects().emitParticles(util.vector().of((double)(0.75f + (float)i * 0.5f), 1.3, 2.5), scene.effects().simpleParticleEmitter((class_2394)class_2398.field_11251, class_243.field_1353), 0.2f, 60);
            scene.effects().emitParticles(util.vector().of((double)(0.75f + (float)i * 0.5f), 1.3, 4.5), scene.effects().simpleParticleEmitter((class_2394)class_2398.field_11251, class_243.field_1353), 0.2f, 60);
        }
        scene.idle(70);
        scene.markAsFinished();
        electric.unload();
    }

    public static void connector(SceneBuilder scene, SceneBuildingUtil util) {
        class_2338[] positions;
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("wire_connector", "Wires on poles");
        scene.configureBasePlate(0, 0, 7);
        scene.showBasePlate();
        scene.idle(5);
        for (class_2338 pos : positions = new class_2338[]{util.grid().at(1, 1, 1), util.grid().at(3, 1, 2), util.grid().at(1, 1, 4), util.grid().at(5, 1, 2), util.grid().at(4, 1, 4), util.grid().at(3, 1, 5), util.grid().at(6, 1, 0), util.grid().at(0, 1, 5)}) {
            scene.world().showSection(util.select().position(pos), class_2350.field_11033);
            scene.idle(5);
        }
        electric.connect(positions[0], 0, positions[1], 0);
        scene.idle(5);
        electric.connect(positions[0], 0, positions[2], 0);
        scene.idle(5);
        electric.connect(positions[1], 0, positions[6], 0);
        scene.idle(5);
        scene.overlay().showText(80).text("Wire connectors can be used as attachment points for wires").attachKeyFrame().placeNearTarget();
        electric.connect(positions[1], 0, positions[3], 0);
        scene.idle(5);
        electric.connect(positions[3], 0, positions[4], 0);
        scene.idle(5);
        electric.connect(positions[4], 0, positions[5], 0);
        scene.idle(5);
        electric.connect(positions[1], 0, positions[4], 0);
        scene.idle(5);
        electric.connect(positions[5], 0, positions[7], 0);
        scene.idle(70);
        scene.markAsFinished();
        electric.unload();
    }

    public static void grounding(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("grounding", "Ground reference");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(60).text("The grounding rod provides a 0V ground reference to your grid").pointAt(util.vector().of(2.5, 1.125, 2.5)).placeNearTarget().attachKeyFrame();
        scene.idle(70);
        scene.overlay().showText(60).text("You can use it to transfer power but you must be careful...").placeNearTarget().attachKeyFrame();
        scene.idle(70);
        scene.overlay().showText(90).text("High potential and bad ground conditions will cause the ground to become electrified and cause damage to nearby entities.").colored(PonderPalette.RED).placeNearTarget().attachKeyFrame();
        scene.idle(100);
        scene.markAsFinished();
    }

    public static void improvedGround(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("improved_grounding", "Better ground reference");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        ElementLink grass = scene.world().showIndependentSection(util.select().fromTo(1, 2, 1, 3, 3, 3), class_2350.field_11033);
        scene.world().moveSection(grass, util.vector().of(0.0, -1.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(80).text("Regular blocks are not that conductive and will cause your grounding rod to have a high impedance").pointAt(util.vector().topOf(1, 1, 1)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().hideIndependentSection(grass, class_2350.field_11036);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(1, 1, 1, 3, 1, 3), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(80).text("You can improve the ground conditions by adding conductive blocks close to the grounding rod").pointAt(util.vector().topOf(2, 1, 2)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().showSection(util.select().fromTo(1, 2, 1, 3, 3, 3), class_2350.field_11033);
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void insulatedWire(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("insulated_wire", "Insulated Wires");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(5);
        class_2338 t1 = util.grid().at(0, 1, 2);
        class_2338 t2 = util.grid().at(2, 1, 1);
        class_2338 t3 = util.grid().at(2, 1, 3);
        class_2338 t4 = util.grid().at(4, 1, 2);
        scene.electric().connect(t1, 0, t2, 0, class_1767.field_7964);
        scene.electric().connect(t2, 0, t4, 0, class_1767.field_7964);
        scene.electric().connect(t1, 0, t4, 0, class_1767.field_7942);
        scene.electric().connect(t1, 0, t3, 0, class_1767.field_7966);
        scene.electric().connect(t3, 0, t4, 0, class_1767.field_7966);
        scene.idle(10);
        scene.overlay().showText(100).text("Insulated wires can be colored by right clicking them with a dye or by holding a dye in your offhand while placing them.").placeNearTarget().attachKeyFrame();
        scene.idle(110);
        scene.markAsFinished();
    }

    public static void cordJunction(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("cord_junction", "Cord Junctions");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 1, 1), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 2, 4, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 1, 4), class_2350.field_11033);
        scene.idle(5);
        scene.electric().connectCord(new AutoCordEndpoint(util.grid().at(2, 1, 1), 0, 1, util.vector().of(2.5, 1.125, 1.5), null), new AutoCordEndpoint(util.grid().at(3, 1, 2), 0, 1, util.vector().of(3.875, 1.5, 2.5), null));
        scene.idle(5);
        scene.electric().connectCord(new AutoCordEndpoint(util.grid().at(3, 1, 2), 0, 1, util.vector().of(3.875, 1.5, 2.5), null), new AutoCordEndpoint(util.grid().at(1, 1, 3), 0, 1, util.vector().of(1.5, 1.5, 3.875), null));
        scene.idle(10);
        scene.overlay().showText(80).text("Cord junctions allow you to extend and split cords easily").pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11034)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void cordSocket(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("cord_socket", "Cord Sockets");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 4, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.electric().connectCord(new SocketEndpoint(util.grid().at(1, 1, 2)), new SocketEndpoint(util.grid().at(3, 1, 2)));
        scene.idle(10);
        scene.overlay().showText(80).text("Cord sockets allow you to combine simple wires into cords with style").pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11034)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void cord(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("cord", "Cords");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 4, 1, 1), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 1), class_2350.field_11033);
        scene.idle(5);
        scene.electric().connectCord(new SocketEndpoint(util.grid().at(3, 1, 1)), new AutoCordEndpoint(util.grid().at(1, 1, 1), 0, 1, util.vector().of(1.5, 1.125, 1.5), null));
        scene.idle(10);
        scene.overlay().showText(80).text("Cords are 2 strand wires which can make connecting things easier").pointAt(util.vector().of(2.5, 1.25, 1.5)).placeNearTarget().attachKeyFrame();
        scene.idle(100);
        scene.world().showSection(util.select().fromTo(0, 1, 4, 1, 1, 4), class_2350.field_11033);
        scene.idle(10);
        scene.electric().connectCord(new AutoCordEndpoint(util.grid().at(1, 1, 1), 0, 1, util.vector().of(1.5, 1.125, 1.5), null), new SplitCordEndpoint(new BlockWireEndpoint(util.grid().at(1, 1, 4), 0), new BlockWireEndpoint(util.grid().at(0, 1, 4), 0)));
        scene.idle(20);
        scene.overlay().showText(80).text("Cords can be attached to pairs of regular terminals at their ends").pointAt(util.vector().of(1.0, 1.5, 4.5)).placeNearTarget().attachKeyFrame();
        scene.idle(100);
        scene.world().showSection(util.select().position(4, 1, 3), class_2350.field_11033);
        scene.idle(10);
        scene.electric().connectCord(new AutoCordEndpoint(util.grid().at(1, 1, 1), 0, 1, util.vector().of(1.5, 1.125, 1.5), null), new AutoCordEndpoint(util.grid().at(4, 1, 3), 0, 1, util.vector().of(3.8125, 1.25, 3.5), class_2350.field_11039));
        scene.idle(20);
        scene.overlay().showText(60).text("As well as most of consumer devices").pointAt(util.vector().topOf(4, 1, 3)).placeNearTarget().attachKeyFrame();
        scene.idle(70);
        scene.markAsFinished();
    }
}

