/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.createmod.catnip.data.Pair;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;

public class BlockTrace {
    public static class_3965 raycast(class_1937 world, class_243 start, class_243 end, @Nullable ITerminalPlacement passThrough) {
        return (class_3965)class_1922.method_17744((class_243)start, (class_243)end, null, (innerContext, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_265 voxelShape = blockState.method_26218((class_1922)world, pos);
            class_3965 hit = world.method_17745(start, end, pos, voxelShape, blockState);
            if (hit != null && passThrough != null && passThrough.check((class_2338)pos, hit.method_17784())) {
                return null;
            }
            return hit;
        }, innerContext -> {
            class_243 heading = start.method_1020(end);
            return class_3965.method_17778((class_243)end, (class_2350)class_2350.method_10142((double)heading.field_1352, (double)heading.field_1351, (double)heading.field_1350), (class_2338)class_2338.method_49638((class_2374)end));
        });
    }

    public static class_3965 raycast(class_1937 world, class_243 start, class_243 end) {
        class_2338 ignore1 = class_2338.method_49638((class_2374)start);
        class_2338 ignore2 = class_2338.method_49638((class_2374)end);
        return (class_3965)class_1922.method_17744((class_243)start, (class_243)end, null, (innerContext, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_265 voxelShape = blockState.method_26218((class_1922)world, pos);
            class_3965 hit = world.method_17745(start, end, pos, voxelShape, blockState);
            if (hit != null && (hit.method_17777().equals((Object)ignore1) || hit.method_17777().equals((Object)ignore2))) {
                return null;
            }
            return hit;
        }, innerContext -> {
            class_243 heading = start.method_1020(end);
            return class_3965.method_17778((class_243)end, (class_2350)class_2350.method_10142((double)heading.field_1352, (double)heading.field_1351, (double)heading.field_1350), (class_2338)class_2338.method_49638((class_2374)end));
        });
    }

    private static double clamp(double val, double min, double max) {
        return Math.max(Math.min(val, max), min);
    }

    public static class_243 closestPoint(class_238 box, class_243 point) {
        return new class_243(BlockTrace.clamp(point.field_1352, box.field_1323, box.field_1320), BlockTrace.clamp(point.field_1351, box.field_1322, box.field_1325), BlockTrace.clamp(point.field_1350, box.field_1321, box.field_1324));
    }

    private static BlockWireEntity.Point makePoint(class_243 start, class_243 end) {
        double distX = end.field_1352 - start.field_1352;
        double distY = end.field_1351 - start.field_1351;
        double distZ = end.field_1350 - start.field_1350;
        double lenX = Math.abs(distX);
        double lenY = Math.abs(distY);
        double lenZ = Math.abs(distZ);
        if (lenX > lenY && lenX > lenZ) {
            return BlockWireEntity.Point.x((float)distX);
        }
        if (lenY > lenZ) {
            return BlockWireEntity.Point.y((float)distY);
        }
        return BlockWireEntity.Point.z((float)distZ);
    }

    public static class_243 alignPosition(class_243 position) {
        return new class_243((double)((float)((int)Math.round(position.field_1352 * 16.0)) / 16.0f), (double)((float)((int)Math.round(position.field_1351 * 16.0)) / 16.0f), (double)((float)((int)Math.round(position.field_1350 * 16.0)) / 16.0f));
    }

    public static TraceResult findPath(class_1937 world, class_243 start, class_243 end, @Nullable ITerminalPlacement terminal, @Nullable class_2350 continueDirection) {
        Pair<TraceState, TraceResult> result = BlockTrace.findPathWithState(world, start, end, terminal, continueDirection);
        if (result == null) {
            return null;
        }
        return (TraceResult)result.getSecond();
    }

    private static TraceCell testDirection(@NotNull class_2350 direction, TraceCell cell, TraceState state, PriorityQueue<TraceCell> visitQueue, int scoreAdjust) {
        class_2382 neighborPos = state.findNextPosition(cell, direction);
        if (neighborPos == null) {
            return null;
        }
        TraceCell neighbor = state.getCell(neighborPos);
        int distance = cell.position.method_19455(neighborPos);
        int newDistance = cell.originDistance + Math.max(distance + (neighbor.isSupported() ? scoreAdjust : 0), 1);
        if (newDistance >= neighbor.originDistance) {
            return null;
        }
        if (!neighbor.isSupported()) {
            int newUnsupportedDistance = cell.unsupportedDistance + distance;
            if (neighbor.unsupportedDistance != 0 && newUnsupportedDistance >= neighbor.unsupportedDistance) {
                return null;
            }
            neighbor.unsupportedDistance = newUnsupportedDistance;
        }
        if (neighbor.unsupportedDistance > 16) {
            return null;
        }
        neighbor.originDistance = newDistance;
        neighbor.backtrace = cell;
        visitQueue.add(neighbor);
        return neighbor;
    }

    public static Pair<TraceState, TraceResult> findPathWithState(class_1937 world, class_243 start, class_243 end, @Nullable ITerminalPlacement terminal, @Nullable class_2350 continueDirection) {
        TraceState state = new TraceState(world, start, end, terminal);
        if (state.target.equals((Object)state.originCell.position) || !state.getCell(state.target).isSupported()) {
            return null;
        }
        PriorityQueue<TraceCell> visitQueue = new PriorityQueue<TraceCell>(Comparator.comparingInt(state::score));
        visitQueue.add(state.originCell);
        int bestScore = Integer.MAX_VALUE;
        TraceCell bestCell = null;
        while (!visitQueue.isEmpty()) {
            int neighborScore;
            TraceCell continuedNeighbor;
            TraceCell cell = visitQueue.poll();
            if (cell.originDistance > 160) continue;
            if (cell.position.equals((Object)state.target)) {
                return Pair.of((Object)state, (Object)new TraceResult(state.traceResult(cell), true));
            }
            if (state.states.size() > 150) break;
            class_2350 prevDirection = cell.cellDirection();
            if (prevDirection == null) {
                prevDirection = continueDirection;
            }
            if (prevDirection != null && (continuedNeighbor = BlockTrace.testDirection(prevDirection, cell, state, visitQueue, -1)) != null && (neighborScore = state.targetDistance(continuedNeighbor)) < bestScore) {
                bestScore = neighborScore;
                bestCell = continuedNeighbor;
            }
            for (class_2350 direction : class_2350.values()) {
                int neighborScore2;
                TraceCell neighbor;
                if (direction == prevDirection || prevDirection != null && direction == prevDirection.method_10153() || (neighbor = BlockTrace.testDirection(direction, cell, state, visitQueue, 0)) == null || (neighborScore2 = state.targetDistance(neighbor)) >= bestScore) continue;
                bestScore = neighborScore2;
                bestCell = neighbor;
            }
        }
        if (bestCell != null) {
            return Pair.of((Object)state, (Object)new TraceResult(state.traceResult(bestCell), false));
        }
        return Pair.of((Object)state, null);
    }

    public static class TraceState {
        public static final int GRID_SIZE = 16;
        public static final float UNIT_SIZE = 0.0625f;
        public static final float HALF_UNIT = 0.03125f;
        public final Map<class_2382, TraceCell> states = new HashMap<class_2382, TraceCell>();
        public final class_1937 world;
        public final class_243 origin;
        public final class_2382 target;
        public final TraceCell originCell;
        @Nullable
        public final ITerminalPlacement terminal;

        public TraceState(class_1937 world, class_243 origin, class_243 target, @Nullable ITerminalPlacement terminal) {
            this.world = world;
            this.origin = new class_243(Math.floor(origin.field_1352), Math.floor(origin.field_1351), Math.floor(origin.field_1350));
            class_2382 originPos = this.transform(origin);
            this.originCell = this.createCell(originPos, 0);
            this.states.put(originPos, this.originCell);
            this.target = this.transform(target);
            this.terminal = terminal;
        }

        public class_2382 transform(class_243 pos) {
            return new class_2382((int)Math.floor((pos.field_1352 - this.origin.field_1352) * 16.0), (int)Math.floor((pos.field_1351 - this.origin.field_1351) * 16.0), (int)Math.floor((pos.field_1350 - this.origin.field_1350) * 16.0));
        }

        public class_243 transform(class_2382 pos) {
            return new class_243((double)((float)pos.method_10263() * 0.0625f) + this.origin.field_1352, (double)((float)pos.method_10264() * 0.0625f) + this.origin.field_1351, (double)((float)pos.method_10260() * 0.0625f) + this.origin.field_1350);
        }

        public class_243 transform(TraceCell cell) {
            return this.transform(cell.position);
        }

        public boolean isSupport(class_2382 position) {
            class_243 worldPos = this.transform(position);
            class_2338 blockPos = class_2338.method_49638((class_2374)worldPos);
            class_2680 state = this.world.method_8320(blockPos);
            return state.method_26212((class_1922)this.world, blockPos);
        }

        @NotNull
        public TraceCell createCell(class_2382 position, int length) {
            boolean isSupported = false;
            for (class_2350 dir : class_2350.values()) {
                if (!position.equals((Object)this.target) && !this.isSupport(position.method_35853(dir.method_10163()))) continue;
                isSupported = true;
                break;
            }
            TraceCell cell = new TraceCell(position, length, isSupported);
            this.states.put(position, cell);
            return cell;
        }

        public void writeCell(class_2382 position, class_243 nudge) {
            if (!this.states.containsKey(position)) {
                TraceCell cell = this.createCell(position, Integer.MAX_VALUE);
                cell.nudge = nudge;
            }
        }

        @NotNull
        public TraceCell getCell(class_2382 cellPos) {
            if (!this.states.containsKey(cellPos)) {
                return this.createCell(cellPos, Integer.MAX_VALUE);
            }
            return this.states.get(cellPos);
        }

        public int score(TraceCell cell) {
            return cell.originDistance + this.targetDistance(cell);
        }

        public int targetDistance(TraceCell cell) {
            return cell.position.method_19455(this.target);
        }

        public int offsetToFullBlock(int coordinate, class_2350.class_2352 direction) {
            int offset = 0;
            switch (direction) {
                case field_11056: {
                    if (coordinate >= 0) {
                        offset = 16 - coordinate % 16;
                        break;
                    }
                    offset = -(coordinate % 16);
                    break;
                }
                case field_11060: {
                    offset = coordinate >= 0 ? -(coordinate % 16) : -(16 + coordinate % 16);
                }
            }
            return offset;
        }

        @Nullable
        public class_2382 raycastNextPosition(TraceCell currentCell, class_2350 dir) {
            class_2350 side;
            class_2382 retPos;
            class_2350.class_2351 axis = dir.method_10166();
            class_2382 currentPos = currentCell.position;
            int axialLength = Math.abs(this.target.method_30558(axis) - currentPos.method_30558(axis));
            class_3965 hit = null;
            for (class_2350 castOffsetDir : class_2350.values()) {
                class_243 castEnd;
                class_243 castStart;
                if (castOffsetDir.method_10166() != dir.method_10166() && !(hit = BlockTrace.raycast(this.world, castStart = this.transform(currentCell).method_43206(castOffsetDir, 0.03125), castEnd = castStart.method_43206(dir, (double)((float)axialLength * 0.0625f)), this.terminal)).method_17781()) break;
            }
            if (hit == null) {
                return null;
            }
            if (hit.method_17781()) {
                int axisCoordinate = currentPos.method_30558(axis);
                int offset = this.offsetToFullBlock(axisCoordinate, dir.method_10171());
                if (Math.abs(offset) > 8) {
                    return null;
                }
                return currentPos.method_35850(axis, offset);
            }
            class_2382 cellPos = this.transform(hit.method_17784());
            switch (hit.method_17783()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_1333: {
                    class_2382 class_23822 = cellPos;
                    break;
                }
                case field_1331: {
                    class_2382 class_23822 = null;
                    break;
                }
                case field_1332: {
                    class_2382 class_23822 = retPos = cellPos;
                }
            }
            if (retPos != null && (side = hit.method_17780()).method_10171() == class_2350.class_2352.field_11060) {
                this.writeCell(cellPos, class_243.field_1353.method_38499(side.method_10166(), -0.03125));
            }
            return retPos;
        }

        @Nullable
        public class_2382 findNextPosition(TraceCell currentCell, class_2350 dir) {
            class_2350.class_2351 axis = dir.method_10166();
            class_2382 currentPos = currentCell.position;
            class_2382 castPos = this.raycastNextPosition(currentCell, dir);
            if (castPos == null || currentPos.equals((Object)castPos)) {
                return null;
            }
            int axisCoordinate = currentPos.method_30558(axis);
            int boundaryOffset = this.offsetToFullBlock(axisCoordinate, dir.method_10171());
            if (boundaryOffset == 0) {
                boundaryOffset = -16;
            }
            int nextBoundary = axisCoordinate + boundaryOffset;
            int raycastBoundary = castPos.method_30558(axis);
            if (Math.abs(nextBoundary - axisCoordinate) > Math.abs(raycastBoundary - axisCoordinate)) {
                return currentPos.method_35850(axis, raycastBoundary - axisCoordinate);
            }
            return currentPos.method_35850(axis, nextBoundary - axisCoordinate);
        }

        public List<class_2382> traceback(TraceCell cell) {
            ArrayList<class_2382> positions = new ArrayList<class_2382>();
            class_2350.class_2351 currentAxis = null;
            class_2382 lastPosition = cell.position;
            while (cell.backtrace != null) {
                cell = cell.backtrace;
                class_2350.class_2351 axis = cell.position.method_10263() != lastPosition.method_10263() ? class_2350.class_2351.field_11048 : (cell.position.method_10264() != lastPosition.method_10264() ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
                if (axis != currentAxis) {
                    positions.add(0, lastPosition);
                    currentAxis = axis;
                }
                lastPosition = cell.position;
            }
            positions.add(0, lastPosition);
            return positions;
        }

        public List<BlockWireEntity.Point> traceResult(TraceCell cell) {
            ArrayList pathPoints = new ArrayList();
            this.traceback(cell).forEach(p -> pathPoints.add(this.transform((class_2382)p)));
            ArrayList<BlockWireEntity.Point> result = new ArrayList<BlockWireEntity.Point>();
            class_243 current = this.transform(this.originCell.position);
            for (class_243 point : pathPoints) {
                BlockWireEntity.Point segment = BlockTrace.makePoint(current, point);
                if (segment.gridLength > 0) {
                    result.add(segment);
                }
                current = point;
            }
            return result;
        }
    }

    public record TraceResult(List<BlockWireEntity.Point> points, boolean reachedTarget) {
    }

    public static class TraceCell {
        public final class_2382 position;
        public int originDistance;
        public TraceCell backtrace;
        public boolean isSupported;
        public int unsupportedDistance;
        public boolean isInside;
        public class_243 nudge = class_243.field_1353;

        public TraceCell(class_2382 position, int originDistance, boolean isSupported) {
            this.position = position;
            this.originDistance = originDistance;
            this.isSupported = isSupported;
            this.unsupportedDistance = 0;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        @Nullable
        public class_2350 cellDirection() {
            if (this.backtrace == null) {
                return null;
            }
            class_2382 p1 = this.backtrace.position;
            class_2382 p2 = this.position;
            return class_2350.method_50026((int)(p2.method_10263() - p1.method_10263()), (int)(p2.method_10264() - p1.method_10264()), (int)(p2.method_10260() - p1.method_10260()));
        }
    }
}

