/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.theme.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.info.TerminalHandler;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlockEntity;
import org.patryk3211.powergrid.electricity.wire.WirePreview;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItemRenderer;
import org.patryk3211.powergrid.equipment.thermometer.ThermometerItemRenderer;
import org.patryk3211.powergrid.mixin.client.BlueprintOverlayRendererAccessor;
import org.patryk3211.powergrid.utility.Lang;

@Environment(value=EnvType.CLIENT)
public class PlacementOverlay {
    private static final List<IOverlayTextProvider> overlayProviders = new ArrayList<IOverlayTextProvider>();
    private static class_2561 prevText = null;
    private static int overlayTicks = -1;
    public static boolean thisActivation = false;

    public static void init() {
        overlayProviders.add(PlacementOverlay::getTransformerText);
        overlayProviders.add(MultimeterItemRenderer::multimeterOverlayText);
        overlayProviders.add(TerminalHandler::overlayText);
        overlayProviders.add(WirePreview::distanceOverlay);
        overlayProviders.add(ThermometerItemRenderer::overlayText);
    }

    public static void setItemRequirement(class_1792 item, int count, boolean hasItems) {
        if (!BlueprintOverlayRendererAccessor.getActive() || !thisActivation) {
            BlueprintOverlayRendererAccessor.setActive(true);
            BlueprintOverlayRendererAccessor.setEmpty(false);
            BlueprintOverlayRendererAccessor.setNoOutput(true);
            thisActivation = true;
            List<Pair<class_1799, Boolean>> ingredients = BlueprintOverlayRendererAccessor.getIngredients();
            ingredients.clear();
            for (int wires = count; wires > 0; wires -= 64) {
                ingredients.add((Pair<class_1799, Boolean>)Pair.of((Object)new class_1799((class_1935)item, Math.min(64, wires)), (Object)hasItems));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderOverlay(class_329 gui, class_332 graphics) {
        class_310 mc = class_310.method_1551();
        if (!mc.field_1690.field_1842 && mc.field_1761.method_2920() != class_1934.field_9219) {
            IOverlayTextProvider provider;
            class_2561 text = null;
            class_746 player = mc.field_1724;
            Iterator<IOverlayTextProvider> iterator = overlayProviders.iterator();
            while (iterator.hasNext() && (text = (provider = iterator.next()).get((class_1657)player)) == null) {
            }
            if (text != null) {
                if (overlayTicks < 10) {
                    ++overlayTicks;
                }
                prevText = text;
            } else if (prevText != null) {
                text = prevText;
                if (--overlayTicks <= 0) {
                    overlayTicks = 0;
                    prevText = null;
                }
            }
            if (text != null) {
                class_1041 window = mc.method_22683();
                int x = (window.method_4486() - gui.method_1756().method_27525((class_5348)text)) / 2;
                int y = window.method_4502() - 61;
                Color color = new Color(4905802);
                float alpha = (float)class_3532.method_15340((int)overlayTicks, (int)0, (int)10) / 10.0f;
                float[] state = Arrays.copyOf(RenderSystem.getShaderColor(), 4);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                graphics.method_51439(gui.method_1756(), text, x, y, color.getRGB(), true);
                RenderSystem.setShaderColor((float)state[0], (float)state[1], (float)state[2], (float)state[3]);
            }
        }
    }

    public static class_2561 getTransformerText(class_1657 player) {
        int[] posArray;
        class_2338 initiatorPos;
        class_1799 wireStack = WirePreview.getUsedWireStack(player);
        if (wireStack == null) {
            return null;
        }
        class_2487 tag = wireStack.method_7969();
        assert (tag != null);
        if (!tag.method_10545("Turns") || !tag.method_10545("Initiator")) {
            return null;
        }
        class_1937 world = player.method_37908();
        class_2680 state = world.method_8320(initiatorPos = new class_2338((posArray = tag.method_10561("Initiator"))[0], posArray[1], posArray[2]));
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof TransformerBlock)) {
            return null;
        }
        TransformerBlock transformerBlock = (TransformerBlock)class_22482;
        Optional<TransformerBlockEntity> transformerOpt = transformerBlock.getBlockEntity(world, initiatorPos, state);
        if (transformerOpt.isEmpty()) {
            return null;
        }
        TransformerBlockEntity transformer = transformerOpt.get();
        int turns = tag.method_10550("Turns");
        if (!transformer.hasPrimary()) {
            return Lang.translateDirect("message.coil_winding_primary", Lang.number(turns).style(class_124.field_1068).component());
        }
        int primaryTurns = transformer.getPrimary().getTurns();
        int largestCommonDenominator = 1;
        for (int i = 2; i <= Math.max(primaryTurns, turns); ++i) {
            if (turns % i != 0 || primaryTurns % i != 0) continue;
            largestCommonDenominator = i;
        }
        LangBuilder n1 = Lang.number(primaryTurns / largestCommonDenominator);
        LangBuilder n2 = Lang.number(turns / largestCommonDenominator);
        LangBuilder ratio = n1.add(class_2561.method_30163((String)":")).add(n2);
        return Lang.translateDirect("message.coil_winding_secondary", Lang.number(turns).style(class_124.field_1068).component(), ratio.style(class_124.field_1068).component());
    }

    public static interface IOverlayTextProvider {
        @Nullable
        public class_2561 get(class_1657 var1);
    }
}

