/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.DeferredRegister;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import org.patryk3211.powergrid.AbstractPowerGridRegistrate;
import org.patryk3211.powergrid.circuits.components.Components;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedCommands;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedDisplaySources;
import org.patryk3211.powergrid.collections.ModdedEntities;
import org.patryk3211.powergrid.collections.ModdedFluids;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedMenus;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedParticles;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlockEntity;
import org.patryk3211.powergrid.electricity.electromagnet.recipe.MagnetizingRecipe;
import org.patryk3211.powergrid.electricity.electromagnet.recipe.TypeInfo;
import org.patryk3211.powergrid.electricity.heater.HeaterFanProcessingTypes;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.equipment.thunder.LightningRodMovementBehaviour;
import org.patryk3211.powergrid.forge.PowerGridImpl;
import org.patryk3211.powergrid.utility.proxy.SubstituteBlockEntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerGrid {
    public static final String MOD_ID = "powergrid";
    public static final Logger LOGGER = LoggerFactory.getLogger(PowerGrid.class);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"powergrid", (ResourceKey)Registries.f_256764_);
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"powergrid", (ResourceKey)Registries.f_256954_);
    public static final DeferredRegister<FanProcessingType> FAN_PROCESSING_TYPES = DeferredRegister.create((String)"powergrid", (ResourceKey)CreateRegistries.FAN_PROCESSING_TYPE);
    public static AbstractPowerGridRegistrate REGISTRATE;
    private static Platform platform;

    public static void init() {
        LOGGER.info("Power grid starting, prepare to be electrocuted");
        ElectricalNetwork.LOGGER = LOGGER;
        ModdedSoundEvents.prepare();
        REGISTRATE = PowerGrid.createRegistrate();
        PowerGrid.register();
        PowerGrid.registerArchitecturyEvents();
        ModdedPackets.registerPackets();
    }

    public static void registerArchitecturyEvents() {
        TickEvent.ServerLevelTick.SERVER_LEVEL_PRE.register(GlobalElectricNetworks::tick);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(GlobalElectricNetworks::unloadWorld);
        CommandRegistrationEvent.EVENT.register(ModdedCommands::register);
    }

    private static void register() {
        PowerGrid.registerRecipes();
        HeaterFanProcessingTypes.register();
        SubstituteBlockEntityProvider.INSTANCE.registerDefault(DeviceConnectorBlockEntity.class, DeviceConnectorBlockEntity::new);
        SubstituteBlockEntityProvider.INSTANCE.lock();
        ModdedDisplaySources.register();
        ModdedBlocks.register();
        ModdedItems.register();
        ModdedFluids.register();
        ModdedBlockEntities.register();
        ModdedEntities.register();
        ModdedConfigs.register();
        ModdedMenus.register();
        Components.register();
        ModdedParticles.register();
        PowerGrid.finalizeRegistrate();
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
        FAN_PROCESSING_TYPES.register();
        ModdedParticles.PARTICLE_TYPES.register();
        MovementBehaviour.REGISTRY.register((Object)Blocks.f_152587_, (Object)new LightningRodMovementBehaviour());
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation texture(String path) {
        return PowerGrid.asResource("textures/" + path + ".png");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static AbstractPowerGridRegistrate createRegistrate() {
        return PowerGridImpl.createRegistrate();
    }

    public static void registerRecipes() {
        TypeInfo magnetizing = MagnetizingRecipe.TYPE_INFO;
        RECIPE_SERIALIZERS.register(magnetizing.getId(), magnetizing::getSerializer);
        RECIPE_TYPES.register(magnetizing.getId(), magnetizing::getType);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        PowerGridImpl.finalizeRegistrate();
    }

    public static Platform getPlatform() {
        if (platform == null) {
            String str = System.getProperty("powergrid.platform", "auto");
            platform = switch (str.toLowerCase()) {
                case "fabric" -> Platform.FABRIC;
                case "forge" -> Platform.FORGE;
                case "auto" -> {
                    if (dev.architectury.platform.Platform.isForge()) {
                        yield Platform.FORGE;
                    }
                    if (dev.architectury.platform.Platform.isFabric()) {
                        yield Platform.FABRIC;
                    }
                    throw new IllegalStateException("Cannot detect current platform");
                }
                default -> throw new IllegalArgumentException("Unknown output platform specified, allowed values: [fabric, forge]");
            };
        }
        return platform;
    }

    public static <T> T forPlatform(T fabric, T forge) {
        return switch (PowerGrid.getPlatform().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> fabric;
            case 1 -> forge;
        };
    }

    static {
        platform = null;
    }

    public static enum Platform {
        FABRIC,
        FORGE;

    }
}

