/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.GaugeComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.gauge.VoltageGaugeBlockEntity;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class VoltageGaugeComponent
extends GaugeComponent {
    public static final FloatProperty MAX_VOLTAGE = new FloatProperty("powergrid", "voltage_gauge_max", 10.0f, 1.0f, 100.0f);

    public VoltageGaugeComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object)MAX_VOLTAGE);
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        ElectricWire wire = builder.connect(10000.0f, builder.terminalNode(0), builder.terminalNode(1));
        placed.add(wire);
    }

    @Override
    public float getTarget(PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return 0.0f;
        }
        AbstractElectricWire wire = placed.wires.get(0);
        return Mth.m_14036_((float)(Math.abs(wire.potentialDifference()) / placed.get(MAX_VOLTAGE).floatValue()), (float)0.0f, (float)1.125f);
    }

    public float getValue(PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return 0.0f;
        }
        AbstractElectricWire wire = placed.wires.get(0);
        return Math.abs(wire.potentialDifference());
    }

    @Override
    public boolean addToGoggleTooltip(PlacedComponent component, List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(component, tooltip, isPlayerSneaking);
        Float max = component.get(MAX_VOLTAGE);
        VoltageGaugeBlockEntity.addTooltip(tooltip, this.getValue(component), max.floatValue());
        return true;
    }
}

