/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.wire.WireItem;

public class WireValues {
    private static final List<Provider> providers = new ArrayList<Provider>();

    public static float resistance(WireItem wire) {
        return WireValues.get(wire, Provider::resistance);
    }

    public static float maxLength(WireItem wire) {
        return WireValues.get(wire, Provider::maxLength);
    }

    public static float thermalMass(WireItem wire) {
        return WireValues.get(wire, Provider::thermalMass);
    }

    public static float dissipationFactor(WireItem wire) {
        return WireValues.get(wire, Provider::dissipationFactor);
    }

    private static float get(WireItem wire, BiFunction<Provider, WireItem, DoubleSupplier> map) {
        for (Provider provider : providers) {
            DoubleSupplier v = map.apply(provider, wire);
            if (v == null) continue;
            return (float)v.getAsDouble();
        }
        throw new IllegalArgumentException("Wire '" + String.valueOf(wire) + "' not found in any provider");
    }

    public static void register(Provider provider) {
        providers.add(provider);
    }

    public static interface Provider {
        @Nullable
        public DoubleSupplier resistance(WireItem var1);

        @Nullable
        public DoubleSupplier maxLength(WireItem var1);

        @Nullable
        public DoubleSupplier thermalMass(WireItem var1);

        @Nullable
        public DoubleSupplier dissipationFactor(WireItem var1);
    }
}

