/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedDamageTypes;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public class ThermalBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ThermalBehaviour> TYPE = new BehaviourType("thermal");
    public static final float BASE_TEMPERATURE = 22.0f;
    public static final int OVERHEAT_TICKS = 2;
    public static final int OVERHEAT_PARTICLES = 1;
    public static final int OVERHEAT_EXPLOSION = 2;
    public static final int IGNORE_EXTRA_COOLING = 4;
    private float temperature;
    private float prevTemperature;
    private int overheatTicks;
    private float thermalMass;
    private float dissipationFactor;
    private final float overheatTemperature;
    private AirCurrent coolingAir;
    private float coolingFactorMultiplier;
    private BlockPos trackedBehaviour;
    private int behaviourFlags = 3;
    private Runnable overheatCallback;
    private boolean firstTick = true;

    protected ThermalBehaviour(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        super(be);
        this.thermalMass = thermalMass;
        this.dissipationFactor = dissipationFactor;
        this.overheatTemperature = overheatTemperature;
        this.temperature = 22.0f;
        this.coolingFactorMultiplier = 1.0f;
        if (!ThermalBehaviour.shouldOverheat()) {
            this.behaviourFlags = 0;
        }
    }

    @Nullable
    public static ThermalBehaviour simple(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        if (!ThermalBehaviour.shouldOverheat()) {
            return null;
        }
        return new ThermalBehaviour(be, thermalMass, dissipationFactor, overheatTemperature);
    }

    @NotNull
    public static ThermalBehaviour always(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        return new ThermalBehaviour(be, thermalMass, dissipationFactor, overheatTemperature);
    }

    @Nullable
    public static ThermalBehaviour simple(SmartBlockEntity be, float thermalMass, float dissipationFactor) {
        return ThermalBehaviour.simple(be, thermalMass, dissipationFactor, 175.0f);
    }

    @Nullable
    public static ThermalBehaviour forMaxPower(SmartBlockEntity be, float thermalMass, float power) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, power, 175.0f);
    }

    @Nullable
    public static ThermalBehaviour fromConfig(SmartBlockEntity be) {
        Block block = be.m_58900_().m_60734_();
        return ThermalBehaviour.forMaxPower(be, ThermalValues.getMass(block), ThermalValues.getPower(block));
    }

    @Nullable
    public static ThermalBehaviour fromConfig(SmartBlockEntity be, float overheatTemperature) {
        Block block = be.m_58900_().m_60734_();
        return ThermalBehaviour.forMaxPower(be, ThermalValues.getMass(block), ThermalValues.getPower(block), overheatTemperature);
    }

    public static float dissipationFactor(float power, float temperature) {
        return power / (temperature - 22.0f);
    }

    @Nullable
    public static ThermalBehaviour forMaxPower(SmartBlockEntity be, float thermalMass, float power, float overheatTemperature) {
        float targetTemperature = overheatTemperature - 25.0f;
        return ThermalBehaviour.simple(be, thermalMass, ThermalBehaviour.dissipationFactor(power, targetTemperature), overheatTemperature);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float thermalMass) {
        return ThermalBehaviour.forVoltageAtResistance(be, voltage, ((IElectricEntity)be).resistance(), thermalMass, 175.0f);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float resistance, float thermalMass) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, voltage * voltage / resistance, 175.0f);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float resistance, float thermalMass, float overheatTemperature) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, voltage * voltage / resistance, overheatTemperature);
    }

    public static boolean shouldExplode() {
        return (Boolean)ModdedConfigs.server().electricity.explosiveDeconstruction.get();
    }

    public static boolean shouldOverheat() {
        return (Boolean)ModdedConfigs.server().electricity.overheating.get();
    }

    public ThermalBehaviour behaviourFlags(int flags) {
        this.behaviourFlags = flags;
        return this;
    }

    public ThermalBehaviour overheatCallback(Runnable callback) {
        this.overheatCallback = callback;
        return this;
    }

    public void track(@Nullable ThermalBehaviour other) {
        if (other == this || other == null) {
            this.trackedBehaviour = null;
            return;
        }
        this.trackedBehaviour = other.getPos();
    }

    public void resetTemperature() {
        this.temperature = 22.0f;
    }

    public void setDissipationFactor(float dissipationFactor) {
        this.dissipationFactor = dissipationFactor;
    }

    public void setThermalMass(float mass) {
        this.thermalMass = mass;
    }

    public void noCooling() {
        this.coolingFactorMultiplier = 1.0f;
        this.coolingAir = null;
    }

    public void setCoolingMultiplier(AirCurrent current, float value) {
        if ((this.behaviourFlags & 4) != 0) {
            return;
        }
        this.coolingFactorMultiplier = value;
        this.coolingAir = current;
    }

    public void tick() {
        ThermalBehaviour tracked;
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            return;
        }
        ThermalBehaviour thermalBehaviour = tracked = this.trackedBehaviour != null ? (ThermalBehaviour)ThermalBehaviour.get((BlockGetter)this.getWorld(), (BlockPos)this.trackedBehaviour, TYPE) : null;
        if (tracked != null) {
            this.temperature = tracked.temperature;
        }
        if (this.coolingAir != null && (this.coolingAir.source.isSourceRemoved() || this.coolingAir.source.getSpeed() == 0.0f)) {
            this.noCooling();
        }
        if (tracked == null) {
            float dissipatedPower = this.dissipationFactor * this.coolingFactorMultiplier * (this.temperature - 22.0f);
            this.temperature -= dissipatedPower / 20.0f / this.thermalMass;
            if (dissipatedPower > 0.0f && this.temperature < 22.0f) {
                this.temperature = 22.0f;
            }
            if (dissipatedPower != 0.0f) {
                this.blockEntity.m_6596_();
            }
        }
        if (!Float.isFinite(this.temperature)) {
            this.temperature = 22.0f;
            this.prevTemperature = 22.0f;
        }
        float temperatureDelta = this.temperature - this.prevTemperature;
        this.prevTemperature = this.temperature;
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world.f_46443_ && (this.behaviourFlags & 1) != 0) {
            RandomSource random = this.getWorld().m_213780_();
            float x = (float)pos.m_123341_() + random.m_188501_();
            float y = (float)pos.m_123342_() + random.m_188501_();
            float z = (float)pos.m_123343_() + random.m_188501_();
            if (this.temperature >= this.overheatTemperature - 50.0f) {
                float chance = (this.temperature - this.overheatTemperature + 100.0f) / 100.0f;
                if (random.m_188501_() < chance) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)x, (double)y, (double)z, 0.0, (double)0.05f, 0.0);
                }
            }
        }
        if (this.isOverheated() && !world.f_46443_) {
            if (temperatureDelta > 0.0f && this.overheatTicks++ >= 2) {
                if (this.overheatCallback != null) {
                    this.overheatCallback.run();
                }
                if ((this.behaviourFlags & 2) != 0) {
                    ThermalBehaviour.explode(world, pos, this.blockEntity.m_58900_(), 1.0f);
                }
            } else if (temperatureDelta <= 0.0f) {
                this.overheatTicks = 0;
                if (this.temperature > this.overheatTemperature + 10.0f) {
                    this.temperature = this.overheatTemperature + 10.0f;
                    this.blockEntity.sendData();
                }
            }
        }
    }

    public static void explode(Level world, BlockPos pos, BlockState state, float power) {
        if (ThermalBehaviour.shouldExplode()) {
            Registry registry = world.m_9598_().m_175515_(Registries.f_268580_);
            MachineOverloadDamageSource source = new MachineOverloadDamageSource((Holder<DamageType>)((Holder)registry.m_203636_(ModdedDamageTypes.OVERLOADED_MACHINE).get()), state.m_60734_());
            world.m_46961_(pos, false);
            world.m_254877_(null, (DamageSource)source, null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), power, false, Level.ExplosionInteraction.BLOCK);
        } else {
            world.m_46961_(pos, false);
        }
    }

    public boolean isOverheated() {
        return this.temperature >= this.overheatTemperature;
    }

    public void applyTickPower(float power) {
        if (Float.isFinite(power)) {
            float energy = power / 20.0f;
            this.temperature += energy / this.thermalMass;
        }
    }

    public void applyWirePower(AbstractElectricWire wire) {
        if (wire.isConverged()) {
            this.applyTickPower(wire.power());
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.temperature = nbt.m_128457_("Temperature");
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128350_("Temperature", this.temperature);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public static class MachineOverloadDamageSource
    extends DamageSource {
        private final Block machine;

        public MachineOverloadDamageSource(Holder<DamageType> type, Block machine) {
            super(type);
            this.machine = machine;
        }

        public Component m_6157_(LivingEntity killed) {
            String translationId = "death.attack." + this.m_269415_().f_268677_();
            LivingEntity primeAdversary = killed.m_21232_();
            MutableComponent machineName = Component.m_237115_((String)this.machine.m_7705_());
            if (primeAdversary != null) {
                return Component.m_237110_((String)(translationId + ".player"), (Object[])new Object[]{killed.m_5446_(), machineName, primeAdversary.m_5446_()});
            }
            return Component.m_237110_((String)translationId, (Object[])new Object[]{killed.m_5446_(), machineName});
        }
    }
}

