/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.tuple.Pair;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.IMultiBlockBattery;

public class CustomConnectivityHandler {
    public static <T extends BlockEntity> void formMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        CustomConnectivityHandler.formMulti(be.m_58903_(), ((IMultiBlockBattery)be).getSpec(), (BlockGetter)be.m_58904_(), cache, frontier);
    }

    private static <T extends BlockEntity> void formMulti(BlockEntityType<?> type, BatterySpec spec, BlockGetter level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = CustomConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction.Axis mainAxis = ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMainConnectionAxis();
        int minX = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (BlockEntity be : frontier) {
            BlockPos pos = be.m_58899_();
            minX = Math.min(pos.m_123341_(), minX);
            minY = Math.min(pos.m_123342_(), minY);
            minZ = Math.min(pos.m_123343_(), minZ);
        }
        if (mainAxis == Direction.Axis.Y) {
            minX -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis != Direction.Axis.Y) {
            minY -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis == Direction.Axis.Y) {
            minZ -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            BlockEntity part = (BlockEntity)frontier.remove(0);
            BlockPos partPos = part.m_58899_();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = CustomConnectivityHandler.tryToFormNewMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (Direction.Axis axis : Iterate.axes) {
                T nextBe;
                Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = partPos.m_121945_(dir);
                if (next.m_123341_() <= minX || next.m_123342_() <= minY || next.m_123343_() <= minZ || visited.contains(next) || (nextBe = CustomConnectivityHandler.partAt(type, spec, level, next)) == null || nextBe.m_58901_()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            BlockEntity toCreate = (BlockEntity)next.getValue();
            if (visited.contains(toCreate.m_58899_())) continue;
            visited.add(toCreate.m_58899_());
            CustomConnectivityHandler.tryToFormNewMulti(toCreate, cache, false);
        }
    }

    private static <T extends BlockEntity> int tryToFormNewMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiBlockEntityContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiBlockEntityContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = CustomConnectivityHandler.tryToFormNewMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            int beWidth = ((IMultiBlockEntityContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiBlockEntityContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            CustomConnectivityHandler.splitMultiAndInvalidate(be, cache, false);
            CustomConnectivityHandler.tryToFormNewMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiBlockEntityContainer)be).preventConnectivityUpdate();
            ((IMultiBlockEntityContainer)be).setWidth(bestWidth);
            ((IMultiBlockEntityContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends BlockEntity> int tryToFormNewMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        int amount = 0;
        int height = 0;
        BlockEntityType type = be.m_58903_();
        Level level = be.m_58904_();
        if (level == null) {
            return 0;
        }
        BlockPos origin = be.m_58899_();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiBlockEntityContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos conPos;
                    Direction.Axis conAxis;
                    BlockEntity controller;
                    int otherWidth;
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(type, ((IMultiBlockBattery)be).getSpec(), (BlockGetter)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiBlockEntityContainer)(controller = (BlockEntity)part.get())).getWidth()) > width || otherWidth == width && ((IMultiBlockEntityContainer)controller).getHeight() == ((IMultiBlockEntityContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiBlockEntityContainer)controller).getMainConnectionAxis()) || !(conPos = controller.m_58899_()).equals((Object)origin) && (axis == Direction.Axis.Y ? conPos.m_123341_() < origin.m_123341_() || conPos.m_123343_() < origin.m_123343_() || conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123343_() + otherWidth > origin.m_123343_() + width : axis == Direction.Axis.Z && conPos.m_123341_() < origin.m_123341_() || conPos.m_123342_() < origin.m_123342_() || axis == Direction.Axis.X && conPos.m_123343_() < origin.m_123343_() || axis == Direction.Axis.Z && conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123342_() + otherWidth > origin.m_123342_() + width || axis == Direction.Axis.X && conPos.m_123343_() + otherWidth > origin.m_123343_() + width)) break block10;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiBlockEntityContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    T part = CustomConnectivityHandler.partAt(type, ((IMultiBlockBattery)be).getSpec(), (BlockGetter)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiBlockEntityContainer)be).modifyExtraData(extraData);
                    ((IMultiBlockBattery)be).inheritEnergy((IMultiBlockBattery)part);
                    CustomConnectivityHandler.splitMultiAndInvalidate(part, cache, false);
                    ((IMultiBlockEntityContainer)part).setController(origin);
                    ((IMultiBlockEntityContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiBlockEntityContainer)part).setHeight(height);
                    ((IMultiBlockEntityContainer)part).setWidth(width);
                    ((IMultiBlockEntityContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiBlockEntityContainer)be).setExtraData(extraData);
        ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        return amount;
    }

    public static <T extends BlockEntity> void splitMulti(T be) {
        CustomConnectivityHandler.splitMultiAndInvalidate(be, null, false);
    }

    private static <T extends BlockEntity> void splitMultiAndInvalidate(T be, @Nullable SearchCache<T> cache, boolean tryReconnect) {
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int width = ((IMultiBlockEntityContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        BlockPos origin = be.m_58899_();
        ArrayList<T> frontier = new ArrayList<T>();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        double energyPerPart = ((IMultiBlockBattery)be).getEnergy() / (double)((IMultiBlockBattery)be).getSize();
        ((IMultiBlockBattery)be).setCapacitySize(1);
        ((IMultiBlockBattery)be).setEnergy(energyPerPart);
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    T partAt = CustomConnectivityHandler.partAt(be.m_58903_(), ((IMultiBlockBattery)be).getSpec(), (BlockGetter)level, pos);
                    if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin)) continue;
                    BlockEntity controllerBE = ((IMultiBlockEntityContainer)partAt).getControllerBE();
                    ((IMultiBlockEntityContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiBlockEntityContainer)controllerBE).getExtraData());
                    ((IMultiBlockEntityContainer)partAt).removeController(true);
                    ((IMultiBlockBattery)partAt).setCapacitySize(1);
                    ((IMultiBlockBattery)partAt).setEnergy(energyPerPart);
                    if (tryReconnect) {
                        frontier.add(partAt);
                        ((IMultiBlockEntityContainer)partAt).preventConnectivityUpdate();
                    }
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
        ((IMultiBlockBattery)be).updateBehaviour();
        ((IMultiBlockBattery)be).markRewire();
        if (tryReconnect) {
            CustomConnectivityHandler.formMulti(be.m_58903_(), ((IMultiBlockBattery)be).getSpec(), (BlockGetter)level, cache == null ? new SearchCache<T>() : cache, frontier);
        }
    }

    private static <T extends BlockEntity> PriorityQueue<Pair<Integer, T>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, T>>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(BlockEntityType<?> type, BatterySpec spec, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be != null && be.m_58903_() == type && !be.m_58901_()) {
            return CustomConnectivityHandler.checked(be, spec);
        }
        return null;
    }

    @Nullable
    private static <T extends BlockEntity> T checked(BlockEntity be, BatterySpec spec) {
        IMultiBlockBattery battery;
        if (be instanceof IMultiBlockBattery && (battery = (IMultiBlockBattery)be).getSpec() == spec) {
            return (T)be;
        }
        return null;
    }

    private static class SearchCache<T extends BlockEntity> {
        Map<BlockPos, Optional<T>> controllerMap = new HashMap<BlockPos, Optional<T>>();

        void put(BlockPos pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(BlockEntityType<?> type, BatterySpec spec, BlockGetter level, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = CustomConnectivityHandler.partAt(type, spec, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = CustomConnectivityHandler.checked(level.m_7702_(((IMultiBlockEntityContainer)partAt).getController()), spec);
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

