/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.patryk3211.powergrid.PowerGrid;

public class PerformanceCounter {
    private static final DateFormat FORMAT = DateFormat.getDateTimeInstance();
    public static final List<PerformanceCounter> COUNTERS = new ArrayList<PerformanceCounter>();
    private String name;
    private int measurementTime = 5000;
    private long microsTotal;
    private long minTime;
    private long maxTime;
    private long epochCount;
    private long start;
    private double prevAvg;
    private long stamp = new Date().getTime();
    private Date lastMeasurement;

    public PerformanceCounter(String name) {
        this.name = name;
        COUNTERS.add(this);
    }

    public void rename(String name) {
        this.name = name;
    }

    public void setMeasurementTime(int measurementTime) {
        this.measurementTime = measurementTime;
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void end() {
        long duration = System.nanoTime() - this.start;
        if (this.minTime == 0L) {
            this.minTime = duration;
        } else if (this.minTime > duration) {
            this.minTime = duration;
        }
        if (this.maxTime < duration) {
            this.maxTime = duration;
        }
        ++this.epochCount;
        this.microsTotal += duration / 1000L;
        Date currentTime = new Date();
        long stampDuration = currentTime.getTime() - this.stamp;
        if (stampDuration >= (long)this.measurementTime) {
            this.prevAvg = (double)this.microsTotal / (double)this.epochCount;
            this.stamp = currentTime.getTime();
            this.reset();
        }
        this.lastMeasurement = currentTime;
    }

    public void reset() {
        this.microsTotal = 0L;
        this.epochCount = 0L;
        this.maxTime = 0L;
        this.minTime = 0L;
    }

    public void log() {
        PowerGrid.LOGGER.info("Performance counter '{}':", (Object)this.name);
        PowerGrid.LOGGER.info("  Min / Max / Avg");
        PowerGrid.LOGGER.info("  {}\u00b5s / {}\u00b5s / {}\u00b5s", new Object[]{Float.valueOf((float)this.minTime / 1000.0f), Float.valueOf((float)this.maxTime / 1000.0f), Float.valueOf((float)this.microsTotal / (float)this.epochCount)});
    }

    public String getName() {
        return this.name;
    }

    public double getMin() {
        return (double)this.minTime / 1000.0;
    }

    public double getMax() {
        return (double)this.maxTime / 1000.0;
    }

    public double getAvg() {
        if (this.epochCount == 0L) {
            return this.prevAvg;
        }
        double weight = (double)this.epochCount / 1000.0;
        return this.prevAvg * 1.0 / (1.0 + weight) + (double)this.microsTotal / (double)this.epochCount * weight / (1.0 + weight);
    }

    public String getTimestamp() {
        return FORMAT.format(this.lastMeasurement);
    }
}

