/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsScreen;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import org.joml.Matrix4f;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlock;
import org.patryk3211.powergrid.network.packets.TransformerWindingC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class TransformerWindingScreen
extends ValueSettingsScreen {
    public static final ResourceLocation CAP_TEXTURE = PowerGrid.texture("gui/brass_cover");
    private final InteractionHand hand;
    private int cap;
    private static int interactionTicks = -1;
    private static TransformerWindingScreen screen = null;

    public static ValueSettingsBoard makeBoard(TransformerBlock block) {
        return new ValueSettingsBoard((Component)Lang.translateDirect("gui.transformer.turns", new Object[0]), block.getMaxTurns(), 10, List.of(Component.m_237113_((String)"N")), new ValueSettingsFormatter(TransformerWindingScreen::formatSettings));
    }

    public static MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return Lang.number(Math.max(1, Math.abs(settings.value()))).component();
    }

    public static boolean beginInteraction(Supplier<TransformerWindingScreen> potentialScreen) {
        if (interactionTicks == -1) {
            interactionTicks = 0;
            screen = potentialScreen.get();
            return true;
        }
        return false;
    }

    public TransformerWindingScreen(TransformerBlock block, InteractionHand hand, int current, int primaryTurns) {
        super(null, TransformerWindingScreen.makeBoard(block), new ValueSettingsBehaviour.ValueSettings(0, current), setting -> {}, 1000);
        this.hand = hand;
        this.cap = block.getMaxTurns() - primaryTurns;
    }

    public ValueSettingsBehaviour.ValueSettings getClosestCoordinate(int mouseX, int mouseY) {
        ValueSettingsBehaviour.ValueSettings value = super.getClosestCoordinate(mouseX, mouseY);
        if (value.value() > this.cap) {
            return new ValueSettingsBehaviour.ValueSettings(value.row(), this.cap);
        }
        return value;
    }

    public static void renderCropped(GuiGraphics graphics, int x, int y, int width, int height, int u, int v) {
        int left = x;
        int top = y;
        int right = left + width;
        int bot = top + height;
        float u1 = (float)u / 256.0f;
        float v1 = (float)v / 256.0f;
        float u2 = u1 + (float)width / 256.0f;
        float v2 = v1 + (float)height / 256.0f;
        Matrix4f m = graphics.m_280168_().m_85850_().m_252922_();
        Color c = Color.WHITE;
        boolean z = false;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(m, (float)left, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v2).m_5752_();
        bufferbuilder.m_252986_(m, (float)right, (float)bot, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_252986_(m, (float)right, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u2, v1).m_5752_();
        bufferbuilder.m_252986_(m, (float)left, (float)top, (float)z).m_6122_(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).m_7421_(u1, v1).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public void renderBarCap(GuiGraphics graphics, int x, int y, int width, ValueSettingsBoard board) {
        int milestoneCount = board.maxValue() / board.milestoneInterval();
        int milestoneSegmentWidth = width / milestoneCount;
        int scale = board.maxValue() > 128 ? 1 : 2;
        int milestone = this.cap / board.milestoneInterval();
        int toMilestoneOffset = milestoneSegmentWidth * milestone + 8 / scale;
        float milestoneFraction = (float)(this.cap - milestone * board.milestoneInterval()) / (float)board.milestoneInterval();
        int offset = (int)((float)toMilestoneOffset + (float)(milestoneSegmentWidth - 7 + 1) * milestoneFraction);
        x += offset;
        --x;
        width -= offset;
        if ((width += 2) <= 2) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CAP_TEXTURE);
        int sideWidth = Math.min(3, width / 2);
        int centerWidth = width - sideWidth * 2;
        TransformerWindingScreen.renderCropped(graphics, x, y, sideWidth, 10, 0, 0);
        TransformerWindingScreen.renderCropped(graphics, x + sideWidth + centerWidth, y, Math.min(3, width - sideWidth), 10, 253, 0);
        for (int w = 0; w < centerWidth; w += 249) {
            int segLen = Math.min(249, centerWidth - w);
            int segX = x + w + sideWidth;
            TransformerWindingScreen.renderCropped(graphics, segX, y, segLen, 10, 3, 0);
        }
    }

    public void renderBarCapMilestone(GuiGraphics graphics, int x, int y, int milestone, ValueSettingsBoard board) {
        int milestoneValue = milestone * board.milestoneInterval();
        if (milestoneValue > this.cap) {
            graphics.m_280218_(CAP_TEXTURE, x, y + 1, 0, 11, 7, 8);
        }
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettingsBehaviour.ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        int value = Math.max(closest.value(), 1);
        ModdedPackets.getChannel().sendToServer((Object)new TransformerWindingC2SPacket(value, this.hand));
        this.m_7379_();
    }

    public static void clientTick() {
        if (interactionTicks == -1) {
            return;
        }
        if (++interactionTicks <= 3) {
            Minecraft mc = Minecraft.m_91087_();
            if (!mc.f_91066_.f_92095_.m_90857_()) {
                interactionTicks = -1;
                return;
            }
            if (interactionTicks == 3) {
                ScreenOpener.open((Screen)screen);
            }
        } else {
            interactionTicks = -1;
        }
    }
}

