/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wireconnector;

import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.electricity.wireconnector.CordJunctionBlockEntity;

public class CordJunctionBlock
extends ElectricBlock
implements IBE<CordJunctionBlockEntity>,
IAcceptCord {
    private static final VoxelShaper SHAPER = VoxelShaper.forDirectional((VoxelShape)CordJunctionBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), (Direction)Direction.DOWN);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public CordJunctionBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public Class<CordJunctionBlockEntity> getBlockEntityClass() {
        return CordJunctionBlockEntity.class;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_43719_().m_122424_());
    }

    public BlockEntityType<? extends CordJunctionBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.CORD_JUNCTION.get();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPER.get((Direction)state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return CordJunctionBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == state.m_61143_((Property)FACING) && !this.m_7898_(state, (LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private static double pickPoint(double location, double center) {
        double diff = location - center;
        if (diff >= 0.125) {
            return 0.1875;
        }
        if (diff <= -0.125) {
            return -0.1875;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public AutoCordEndpoint getEndpoint(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        Vec3i normal = facing.m_122436_();
        Vec3 point = center.m_82520_((double)normal.m_123341_() * 0.40625, (double)normal.m_123342_() * 0.40625, (double)normal.m_123343_() * 0.40625);
        Vec3 loc = context.m_43720_();
        Vec3 offset = new Vec3(CordJunctionBlock.pickPoint(loc.f_82479_, center.f_82479_), CordJunctionBlock.pickPoint(loc.f_82480_, center.f_82480_), CordJunctionBlock.pickPoint(loc.f_82481_, center.f_82481_));
        int sign = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? -1 : 1;
        switch (facing.m_122434_()) {
            case X: {
                if (offset.f_82480_ == 0.0 && offset.f_82481_ == 0.0) {
                    point = point.m_82520_(0.0625 * (double)sign, 0.0, 0.0);
                    break;
                }
                point = point.m_82520_(0.0, offset.f_82480_, offset.f_82481_);
                break;
            }
            case Y: {
                if (offset.f_82479_ == 0.0 && offset.f_82481_ == 0.0) {
                    point = point.m_82520_(0.0, 0.0625 * (double)sign, 0.0);
                    break;
                }
                point = point.m_82520_(offset.f_82479_, 0.0, offset.f_82481_);
                break;
            }
            case Z: {
                point = offset.f_82479_ == 0.0 && offset.f_82480_ == 0.0 ? point.m_82520_(0.0, 0.0, 0.0625 * (double)sign) : point.m_82520_(offset.f_82479_, offset.f_82480_, 0.0);
            }
        }
        return new AutoCordEndpoint(pos, 0, 1, point, null);
    }

    @Override
    @Nullable
    public ITerminalPlacement cordTerminal(BlockState state, Level level, BlockHitResult hit) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Vec3 center = Vec3.m_82512_((Vec3i)hit.m_82425_());
        Vec3i normal = facing.m_122436_();
        Vec3 point = Vec3.f_82478_.m_82520_((double)normal.m_123341_() * 0.40625, (double)normal.m_123342_() * 0.40625, (double)normal.m_123343_() * 0.40625);
        Vec3 loc = hit.m_82450_();
        Vec3 offset = new Vec3(CordJunctionBlock.pickPoint(loc.f_82479_, center.f_82479_), CordJunctionBlock.pickPoint(loc.f_82480_, center.f_82480_), CordJunctionBlock.pickPoint(loc.f_82481_, center.f_82481_));
        int sign = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? -1 : 1;
        switch (facing.m_122434_()) {
            case X: {
                if (offset.f_82480_ == 0.0 && offset.f_82481_ == 0.0) {
                    point = point.m_82520_(0.0625 * (double)sign, 0.0, 0.0);
                    break;
                }
                point = point.m_82520_(0.0, offset.f_82480_, offset.f_82481_);
                break;
            }
            case Y: {
                if (offset.f_82479_ == 0.0 && offset.f_82481_ == 0.0) {
                    point = point.m_82520_(0.0, 0.0625 * (double)sign, 0.0);
                    break;
                }
                point = point.m_82520_(offset.f_82479_, 0.0, offset.f_82481_);
                break;
            }
            case Z: {
                point = offset.f_82479_ == 0.0 && offset.f_82480_ == 0.0 ? point.m_82520_(0.0, 0.0, 0.0625 * (double)sign) : point.m_82520_(offset.f_82479_, offset.f_82480_, 0.0);
            }
        }
        point = point.m_82490_(16.0).m_82520_(8.0, 8.0, 8.0);
        return new TerminalBoundingBox(IDecoratedTerminal.CORD, point.f_82479_ - 1.5, point.f_82480_ - 1.5, point.f_82481_ - 1.5, point.f_82479_ + 1.5, point.f_82480_ + 1.5, point.f_82481_ + 1.5);
    }
}

