/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.clutch;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.kinetics.generator.IRotorAssemblyPart;
import org.patryk3211.powergrid.kinetics.generator.clutch.GeneratorClutchBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;

public class GeneratorClutchBlock
extends DirectionalKineticBlock
implements IBE<GeneratorClutchBlockEntity>,
IRotorAssemblyPart {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShaper SHAPER = VoxelShaper.forDirectional((VoxelShape)Shapes.m_83110_((VoxelShape)GeneratorClutchBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0), (VoxelShape)GeneratorClutchBlock.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0)), (Direction)Direction.NORTH).withVerticalShapes(Shapes.m_83110_((VoxelShape)GeneratorClutchBlock.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)GeneratorClutchBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)));

    public GeneratorClutchBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        InteractionResult result = super.onWrenched(state, context);
        if (!result.m_19077_()) {
            return result;
        }
        RotorBehaviour behaviour = (RotorBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)context.m_8083_(), RotorBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.checkConnectivity(null);
        }
        return result;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState initial = super.m_5573_(context);
        if (initial == null) {
            return null;
        }
        return (BlockState)((BlockState)initial.m_61124_((Property)FACING, (Comparable)((Direction)initial.m_61143_((Property)FACING)).m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPER.get((Direction)state.m_61143_((Property)FACING));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        boolean powered = world.m_276867_(pos);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 18);
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.updateStrength(world.m_277086_(pos)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return state.m_61143_((Property)FACING) == face;
    }

    public Class<GeneratorClutchBlockEntity> getBlockEntityClass() {
        return GeneratorClutchBlockEntity.class;
    }

    public BlockEntityType<? extends GeneratorClutchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.GENERATOR_CLUTCH.get();
    }

    @Override
    public boolean canConnect(BlockState state, Direction dir) {
        return state.m_61143_((Property)FACING) == dir.m_122424_();
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredFacing = super.getPreferredFacing(context);
        if (preferredFacing != null) {
            return preferredFacing;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction facing : Direction.values()) {
            IRotorAssemblyPart assembly;
            BlockState state = world.m_8055_(pos.m_5484_(facing, -1));
            Block block = state.m_60734_();
            if (!(block instanceof IRotorAssemblyPart) || !(assembly = (IRotorAssemblyPart)block).canConnect(state, facing)) continue;
            if (preferredFacing == null) {
                preferredFacing = facing;
                continue;
            }
            return null;
        }
        return preferredFacing;
    }
}

