/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.ejml.data.DMatrixRMaj;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class SolverStateS2CPacket
implements SimplePacket {
    private final Map<BlockPos, double[]> solverValues = new HashMap<BlockPos, double[]>();
    public final Set<ChunkPos> chunks = new HashSet<ChunkPos>();

    public SolverStateS2CPacket(Level world, ElectricalNetwork network) {
        for (INode node : network.getNodes()) {
            BlockWireEndpoint endpoint;
            ElectricBehaviour behaviour;
            if (!(node instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode owned = (OwnedFloatingNode)node;
            IWireEndpoint iWireEndpoint = owned.endpoint;
            if (!(iWireEndpoint instanceof BlockWireEndpoint) || (behaviour = (endpoint = (BlockWireEndpoint)iWireEndpoint).getElectricBehaviour(world)) == null || this.solverValues.containsKey(behaviour.getPos())) continue;
            this.chunks.add(new ChunkPos(behaviour.getPos()));
            List<OwnedFloatingNode> external = behaviour.getExternalNodes();
            List<INode> internal = behaviour.getInternalNodes();
            if (external.isEmpty() || behaviour.getNetwork() != network) continue;
            double[] doubles = new double[external.size() + internal.size()];
            int index = 0;
            for (OwnedFloatingNode eNode : behaviour.getExternalNodes()) {
                doubles[index++] = eNode.getStateValue();
            }
            for (INode iNode : behaviour.getInternalNodes()) {
                doubles[index++] = iNode.getStateValue();
            }
            this.solverValues.put(behaviour.getPos(), doubles);
        }
    }

    public SolverStateS2CPacket(FriendlyByteBuf buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            BlockPos pos = buf.m_130135_();
            double[] doubles = new double[buf.readInt()];
            for (int j = 0; j < doubles.length; ++j) {
                doubles[j] = buf.readDouble();
            }
            this.solverValues.put(pos, doubles);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.solverValues.size());
        for (Map.Entry<BlockPos, double[]> entry : this.solverValues.entrySet()) {
            buf.m_130064_(entry.getKey());
            double[] doubles = entry.getValue();
            buf.writeInt(doubles.length);
            for (double value : doubles) {
                buf.writeDouble(value);
            }
        }
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            Level world = ClientSideAccess.world();
            for (Map.Entry<BlockPos, double[]> entry : this.solverValues.entrySet()) {
                double diff;
                ElectricalNetwork network;
                List<OwnedFloatingNode> external;
                ElectricBehaviour behaviour;
                BlockPos pos = entry.getKey();
                if (!world.m_46805_(pos) || (behaviour = (ElectricBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, ElectricBehaviour.TYPE)) == null || (external = behaviour.getExternalNodes()).isEmpty() || (network = behaviour.getNetwork()) == null) continue;
                double[] doubles = entry.getValue();
                int index = 0;
                DMatrixRMaj vector = network.getStateVector();
                if (vector == null) continue;
                for (OwnedFloatingNode eNode : external) {
                    if (vector.getNumRows() <= eNode.getIndex()) continue;
                    diff = doubles[index] - eNode.getStateValue();
                    if (diff > 0.5) {
                        PowerGrid.LOGGER.debug("Solver sync corrected difference of {} at {}", (Object)diff, (Object)pos);
                    }
                    vector.set(eNode.getIndex(), 0, doubles[index++]);
                }
                for (INode iNode : behaviour.getInternalNodes()) {
                    if (vector.getNumRows() <= iNode.getIndex()) continue;
                    diff = doubles[index] - iNode.getStateValue();
                    if (diff > 0.5) {
                        PowerGrid.LOGGER.debug("Solver sync corrected difference of {} at {}", (Object)diff, (Object)pos);
                    }
                    vector.set(iNode.getIndex(), 0, doubles[index++]);
                }
            }
        });
    }
}

