/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsScreen;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.utility.Lang;

@OnlyIn(value=Dist.CLIENT)
public class CustomValueSettingsScreen
extends ValueSettingsScreen {
    private static int interactionTicks = -1;
    private static CustomValueSettingsScreen screen = null;
    private final Consumer<ValueSettingsBehaviour.ValueSettings> saveCallback;

    public static ValueSettingsBoard makeBoard(Component title, int maxValue, int milestoneInterval, List<Component> rows) {
        return new ValueSettingsBoard(title, maxValue, milestoneInterval, rows, new ValueSettingsFormatter(CustomValueSettingsScreen::simpleFormat));
    }

    public static MutableComponent simpleFormat(ValueSettingsBehaviour.ValueSettings settings) {
        return Lang.number(settings.value()).component();
    }

    public static boolean beginInteraction(Supplier<CustomValueSettingsScreen> screenConstructor) {
        if (interactionTicks == -1) {
            interactionTicks = 0;
            screen = screenConstructor.get();
            return true;
        }
        return false;
    }

    public CustomValueSettingsScreen(BlockPos pos, ValueSettingsBoard board, ValueSettingsBehaviour.ValueSettings valueSettings, Consumer<ValueSettingsBehaviour.ValueSettings> saveCallback) {
        super(pos, board, valueSettings, $ -> {}, 1001);
        this.saveCallback = saveCallback;
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettingsBehaviour.ValueSettings closest = this.getClosestCoordinate((int)pMouseX, (int)pMouseY);
        this.saveCallback.accept(closest);
        this.m_7379_();
    }

    public static void clientTick() {
        if (interactionTicks == -1) {
            return;
        }
        if (++interactionTicks <= 3) {
            Minecraft mc = Minecraft.m_91087_();
            if (!mc.f_91066_.f_92095_.m_90857_()) {
                interactionTicks = -1;
                return;
            }
            if (interactionTicks == 3) {
                ScreenOpener.open((Screen)screen);
            }
        } else {
            interactionTicks = -1;
        }
    }
}

