/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.utility.forge.PlayerLookupImpl;

public final class PlayerLookup {
    public static Collection<ServerPlayer> all(MinecraftServer server) {
        Objects.requireNonNull(server, "The server cannot be null");
        if (server.m_6846_() != null) {
            return Collections.unmodifiableCollection(server.m_6846_().m_11314_());
        }
        return Collections.emptyList();
    }

    public static Collection<ServerPlayer> world(ServerLevel world) {
        Objects.requireNonNull(world, "The world cannot be null");
        return Collections.unmodifiableCollection(world.m_6907_());
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<ServerPlayer> tracking(Entity entity) {
        return PlayerLookupImpl.tracking(entity);
    }

    public static Collection<ServerPlayer> tracking(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null");
        if (!blockEntity.m_58898_() || blockEntity.m_58904_().m_5776_()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return PlayerLookup.tracking((ServerLevel)blockEntity.m_58904_(), blockEntity.m_58899_());
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return PlayerLookup.tracking(world, new ChunkPos(pos));
    }

    public static Collection<ServerPlayer> around(ServerLevel world, Vec3 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.m_20238_(pos) <= radiusSq).collect(Collectors.toList());
    }

    public static Collection<ServerPlayer> around(ServerLevel world, Vec3i pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= radiusSq).collect(Collectors.toList());
    }

    private PlayerLookup() {
    }
}

