/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.editor;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.base.IMultiScreenHandlerFactory;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableEditMenu;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableLoadMenu;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableMenu;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.collections.ModdedItems;

public class CircuitDesignTableBlockEntity
extends SmartBlockEntity
implements IMultiScreenHandlerFactory,
ISchematicHolder {
    private final Container inventory = new SimpleContainer(3);
    CircuitSchematic schematic = new CircuitSchematic();
    boolean schematicChanged = false;

    public CircuitDesignTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Schematic", (Tag)this.schematic.serializeNbt());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.schematic.deserializeNbt(tag.m_128469_("Schematic"));
        if (clientPacket) {
            this.schematicChanged = true;
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player, int menuIndex) {
        return switch (menuIndex) {
            case 0 -> CircuitDesignTableMenu.create(syncId, playerInventory, this);
            case 1 -> CircuitDesignTableEditMenu.create(syncId, playerInventory, this);
            case 2 -> CircuitDesignTableLoadMenu.create(syncId, playerInventory, this);
            default -> null;
        };
    }

    public void writeToItem(boolean isCreative) {
        if (!isCreative) {
            ItemStack stack = this.inventory.m_8020_(1);
            if (stack.m_41619_() || this.f_58857_.f_46443_) {
                return;
            }
            stack.m_41774_(1);
        }
        ItemStack result = this.schematic.toItemStack();
        this.inventory.m_6836_(2, result);
        this.schematic.clear();
        this.notifyUpdate();
    }

    public void readFromItem() {
        ItemStack stack = this.inventory.m_8020_(0);
        if (stack.m_41619_() || this.f_58857_.f_46443_ || !stack.m_41782_()) {
            return;
        }
        if (this.inventory.m_8020_(1).m_41619_() && stack.m_150930_((Item)ModdedItems.CIRCUIT_SCHEMATIC.get())) {
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.inventory.m_6836_(1, stack);
        }
        try {
            this.schematic.deserializeNbt(stack.m_41783_().m_128469_("Schematic"));
        }
        catch (RuntimeException e) {
            PowerGrid.LOGGER.error("Failed to load schematic from item: ", (Throwable)e);
        }
        this.notifyUpdate();
    }

    public Component m_5446_() {
        return Component.m_130674_((String)"Circuit Designer");
    }

    @Override
    @NotNull
    public String getSchematicName() {
        String name = this.schematic.getName();
        return name != null ? name : Component.m_237115_((String)"item.powergrid.circuit_schematic.empty").getString();
    }

    @Override
    public void setSchematicName(String name) {
        this.schematic.setName(name);
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public CircuitSchematic getSchematic() {
        return this.schematic;
    }

    @Override
    public void setSchematic(CircuitSchematic schematic) {
        this.schematic = schematic;
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }
}

