/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.ViaComponent;
import org.patryk3211.powergrid.circuits.schematic.Area;
import org.patryk3211.powergrid.circuits.schematic.CircuitLayer;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.schematic.Point;
import org.patryk3211.powergrid.collections.ModdedItems;

public class CircuitSchematic {
    private final CircuitLayer front = new CircuitLayer();
    private final CircuitLayer back = new CircuitLayer();
    private final CircuitLayer pads = new CircuitLayer();
    private final List<PlacedComponent> components = new ArrayList<PlacedComponent>();
    @Nullable
    private String name;

    public CircuitSchematic() {
    }

    public CircuitSchematic(CircuitSchematic schematic) {
        this.name = schematic.name;
        this.front.from(schematic.front);
        this.back.from(schematic.back);
        for (PlacedComponent component : schematic.components) {
            PlacedComponent placed = new PlacedComponent(component);
            this.components.add(placed);
            this.addPads(placed);
        }
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public static CircuitSchematic fromNbt(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        CircuitSchematic schematic = new CircuitSchematic();
        schematic.deserializeNbt(nbt);
        return schematic;
    }

    public static CircuitSchematic fromStack(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return null;
        }
        return CircuitSchematic.fromNbt(stack.m_41783_().m_128469_("Schematic"));
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Front", (Tag)this.front.serializeNbt());
        tag.m_128365_("Back", (Tag)this.back.serializeNbt());
        ListTag list = new ListTag();
        for (PlacedComponent component : this.components) {
            list.add((Object)component.serializeNbt());
        }
        tag.m_128365_("Components", (Tag)list);
        if (this.name != null) {
            tag.m_128359_("Name", this.name);
        }
        return tag;
    }

    public void deserializeNbt(CompoundTag tag) {
        try {
            this.front.deserialize(tag.m_128467_("Front"));
            this.back.deserialize(tag.m_128467_("Back"));
            this.name = tag.m_128441_("Name") ? tag.m_128461_("Name") : null;
            this.components.clear();
            ListTag list = tag.m_128437_("Components", 10);
            for (Tag element : list) {
                try {
                    this.components.add(new PlacedComponent((CompoundTag)element));
                }
                catch (RuntimeException e) {
                    PowerGrid.LOGGER.error("Failed to deserialize circuit component NBT", (Throwable)e);
                }
            }
            this.rebuildPads();
        }
        catch (RuntimeException e) {
            this.clear();
            PowerGrid.LOGGER.error("Failed to deserialize circuit schematic NBT", (Throwable)e);
        }
    }

    public void rebuildPads() {
        this.pads.clear();
        for (PlacedComponent placed : this.components) {
            this.addPads(placed);
        }
    }

    private void addPads(PlacedComponent placed) {
        Map<Point, ComponentFootprint.PadData> componentPads = placed.footprint().getPads();
        for (Point point : componentPads.keySet()) {
            this.pads.set(placed.x * 1 + point.x(), placed.y * 1 + point.y());
        }
    }

    public void placeComponent(PlacedComponent basePlacedState, int x, int y) {
        PlacedComponent placed = new PlacedComponent(basePlacedState, x, y);
        this.components.add(placed);
        this.addPads(placed);
    }

    public void removeComponents(int x, int y, int width, int height) {
        this.components.removeIf(placed -> placed.intersects32(x, y, width, height));
        this.rebuildPads();
    }

    @Nullable
    public PlacedComponent getComponent(int x, int y) {
        for (PlacedComponent placed : this.components) {
            ComponentFootprint footprint;
            if (x < placed.x || y < placed.y || x >= placed.x + (footprint = placed.footprint()).getWidth() || y >= placed.y + footprint.getHeight()) continue;
            return placed;
        }
        return null;
    }

    public boolean isPad(int x, int y) {
        return this.pads.get(x, y);
    }

    public CircuitLayer getLayer(Layer layer) {
        return layer == Layer.FRONT ? this.front : this.back;
    }

    public boolean getLayer(Layer layer, int x, int y) {
        return this.getLayer(layer).get(x, y);
    }

    public CircuitLayer front() {
        return this.front;
    }

    public CircuitLayer back() {
        return this.back;
    }

    public CircuitLayer pads() {
        return this.pads;
    }

    public List<PlacedComponent> components() {
        return this.components;
    }

    public ItemStack toItemStack() {
        ItemStack stack = ModdedItems.CIRCUIT_SCHEMATIC.asStack();
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Schematic", (Tag)this.serializeNbt());
        stack.m_41751_(tag);
        if (this.name != null) {
            stack.m_41714_((Component)Component.m_237113_((String)this.name));
        }
        return stack;
    }

    private boolean getAreaState(CircuitLayer layer, int x, int y) {
        return layer.get(x, y);
    }

    public List<Area> calculateAreas(Layer forLayer) {
        ArrayList<Area> areas = new ArrayList<Area>();
        CircuitLayer layer = this.getLayer(forLayer);
        BitSet visitMap = new BitSet(256);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                int y1;
                int x1;
                boolean bit = this.getAreaState(layer, x, y);
                if (!bit || visitMap.get(x + y * 16)) continue;
                for (x1 = x + 1; x1 < 16 && this.getAreaState(layer, x1, y) && !visitMap.get(x1 + y * 16); ++x1) {
                }
                for (y1 = y + 1; y1 < 16 && this.getAreaState(layer, x, y1) && !visitMap.get(x + y1 * 16); ++y1) {
                    boolean isFull = true;
                    for (int i = x; i < x1; ++i) {
                        if (this.getAreaState(layer, i, y1) && !visitMap.get(i + y1 * 16)) continue;
                        isFull = false;
                        break;
                    }
                    if (!isFull) break;
                }
                for (int x2 = x; x2 < x1; ++x2) {
                    for (int y2 = y; y2 < y1; ++y2) {
                        visitMap.set(x2 + y2 * 16);
                    }
                }
                areas.add(new Area(x, y, x1, y1));
            }
        }
        return areas;
    }

    public boolean canPlace(PlacedComponent component, int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        int width = component.footprint().getWidth();
        int height = component.footprint().getHeight();
        if (x + width > 16 || y + height > 16) {
            return false;
        }
        if (!component.canPlace(x, y)) {
            return false;
        }
        ComponentFootprint thisFootprint = component.footprint();
        for (Point pad : thisFootprint.getPads().keySet()) {
            if (!this.pads.get(x * 1 + pad.x(), y * 1 + pad.y())) continue;
            return false;
        }
        boolean thisVia = component.component instanceof ViaComponent;
        for (PlacedComponent placed : this.components) {
            boolean thatVia = placed.component instanceof ViaComponent;
            if (thisVia != thatVia || !placed.intersects(x, y, width, height)) continue;
            return false;
        }
        return true;
    }

    private Optional<Node> makeComponentNode(int x, int y) {
        PlacedComponent placed = this.getComponent(x / 1, y / 1);
        if (placed == null) {
            return Optional.empty();
        }
        ComponentFootprint footprint = placed.footprint();
        int lX = x - placed.x * 1;
        int lY = y - placed.y * 1;
        ComponentFootprint.PadData padData = footprint.getPads().get(new Point(lX, lY));
        if (padData == null || padData.nodeIndex() < 0) {
            return Optional.empty();
        }
        return Optional.of(new Node(placed, padData.nodeIndex()));
    }

    public int getId(@NotNull PlacedComponent placed) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i) != placed) continue;
            return i;
        }
        return -1;
    }

    private boolean shouldVisit(Layer layer, int x, int y, VisitMap visitMap) {
        if (x < 0 || y < 0 || x >= 16 || y >= 16) {
            return false;
        }
        if (!visitMap.canVisit(layer, x, y)) {
            return false;
        }
        return this.getLayer(layer, x, y);
    }

    @NotNull
    public Collection<Node> flood(Layer layer, int x, int y, VisitMap visitMap) {
        if (!visitMap.canVisit(layer, x, y)) {
            return List.of();
        }
        ArrayList<Point> toVisit = new ArrayList<Point>();
        toVisit.add(new Point(x, y));
        HashSet<Node> nodes = new HashSet<Node>();
        while (!toVisit.isEmpty()) {
            int nY;
            Point node = (Point)toVisit.remove(0);
            int nX = node.x();
            if (!visitMap.visit(layer, nX, nY = node.y())) continue;
            if (this.isPad(nX, nY)) {
                Optional<Node> componentNode = this.makeComponentNode(nX, nY);
                componentNode.ifPresent(nodes::add);
                if (this.getLayer(layer.opposite(), nX, nY)) {
                    Collection<Node> componentNodes = this.flood(layer.opposite(), nX, nY, visitMap);
                    nodes.addAll(componentNodes);
                }
            }
            if (this.shouldVisit(layer, nX + 1, nY, visitMap)) {
                toVisit.add(new Point(nX + 1, nY));
            }
            if (this.shouldVisit(layer, nX - 1, nY, visitMap)) {
                toVisit.add(new Point(nX - 1, nY));
            }
            if (this.shouldVisit(layer, nX, nY + 1, visitMap)) {
                toVisit.add(new Point(nX, nY + 1));
            }
            if (!this.shouldVisit(layer, nX, nY - 1, visitMap)) continue;
            toVisit.add(new Point(nX, nY - 1));
        }
        return nodes;
    }

    @NotNull
    public Collection<Node> flood(int x, int y, VisitMap visitMap) {
        if (this.getLayer(Layer.FRONT, x, y)) {
            return this.flood(Layer.FRONT, x, y, visitMap);
        }
        if (this.getLayer(Layer.BACK, x, y)) {
            return this.flood(Layer.BACK, x, y, visitMap);
        }
        return List.of();
    }

    public Collection<Collection<Node>> findNodeBundles() {
        VisitMap visitMap = new VisitMap();
        ArrayList<Collection<Node>> bundles = new ArrayList<Collection<Node>>();
        for (PlacedComponent placed : this.components) {
            for (Point pad : placed.footprint().getPads().keySet()) {
                int y;
                int x = placed.x * 1 + pad.x();
                Collection<Node> nodes = this.flood(x, y = placed.y * 1 + pad.y(), visitMap);
                if (nodes.size() < 2) continue;
                bundles.add(nodes);
            }
        }
        return bundles;
    }

    public void clear() {
        this.front.clear();
        this.back.clear();
        this.pads.clear();
        this.components.clear();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public static enum Layer {
        FRONT,
        BACK;


        public Layer opposite() {
            return this == FRONT ? BACK : FRONT;
        }
    }

    public record Node(PlacedComponent placed, int pad) {
        public float getPadResistance() {
            return this.placed.component.getPadResistance(this.pad);
        }
    }

    public static class VisitMap {
        private final BitSet front = new BitSet(256);
        private final BitSet back = new BitSet(256);

        public boolean visit(Layer layer, int x, int y) {
            BitSet set = layer == Layer.FRONT ? this.front : this.back;
            boolean result = !set.get(x + y * 16);
            set.set(x + y * 16);
            return result;
        }

        public boolean canVisit(Layer layer, int x, int y) {
            BitSet set = layer == Layer.FRONT ? this.front : this.back;
            return !set.get(x + y * 16);
        }
    }
}

