/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class ModIcons
extends AllIcons {
    public static final ResourceLocation ICON_ATLAS = new ResourceLocation("powergrid", "textures/gui/icons.png");
    public static final int ATLAS_SIZE = 64;
    private static int x = 0;
    private static int y = -1;
    public static final ModIcons I_SERIES = ModIcons.newRow();
    public static final ModIcons I_PARALLEL = ModIcons.next();
    public static final ModIcons I_CONNECT = ModIcons.next();
    public static final ModIcons I_CANCEL = ModIcons.next();
    public static final ModIcons I_LAYER_FRONT = ModIcons.newRow();
    public static final ModIcons I_LAYER_BACK = ModIcons.next();
    public static final ModIcons I_RIGHT = ModIcons.next();
    public static final ModIcons I_TOGGLE = ModIcons.next();
    public static final ModIcons I_UPLOAD = ModIcons.newRow();
    private final int iconX;
    private final int iconY;

    public ModIcons(int x, int y) {
        super(0, 0);
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static ModIcons next() {
        return new ModIcons(++x, y);
    }

    private static ModIcons newRow() {
        x = 0;
        return new ModIcons(x, ++y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_ATLAS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.m_280398_(ICON_ATLAS, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 64, 64);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)ICON_ATLAS));
        Matrix4f matrix = ms.m_85850_().m_252922_();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX / 64.0f;
        float u2 = (float)(this.iconX + 16) / 64.0f;
        float v1 = (float)this.iconY / 64.0f;
        float v2 = (float)(this.iconY + 16) / 64.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.m_252986_(matrix, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_).m_6122_(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).m_7421_(u, v).m_85969_(light).m_5752_();
    }
}

