/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.electricity.base.DirectionalElectricBlock;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;

public abstract class SurfaceElectricBlock
extends DirectionalElectricBlock {
    public static final BooleanProperty ALONG_FIRST_AXIS = CustomProperties.ALONG_FIRST_AXIS;

    public SurfaceElectricBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public static BlockStateTerminalCollection surfaceTerminals(Block block, TerminalBoundingBox[] terminalsDown, VoxelShape shapeDown1, VoxelShape shapeDown2, Property<?> ... ignored) {
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)shapeDown1, (Direction)Direction.DOWN);
        VoxelShaper shaper2 = VoxelShaper.forDirectional((VoxelShape)shapeDown2, (Direction)Direction.DOWN);
        return BlockStateTerminalCollection.builder(block).forAllStatesExcept(state -> BlockStateTerminalCollection.each(terminalsDown, terminal -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DOWN: {
                    TerminalBoundingBox terminalBoundingBox = terminal;
                    break;
                }
                case UP: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(180);
                    break;
                }
                case EAST: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(-90);
                    break;
                }
                case WEST: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(90);
                    break;
                }
                case NORTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(90).rotateAroundY(90);
                    break;
                }
                case SOUTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal = terminal.rotateAroundZ(90).rotateAroundY(-90);
                }
            }
            if (!((Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS)).booleanValue()) {
                terminal = terminal.rotate(facing.m_122434_(), 90);
            }
            return terminal;
        }), ignored).withShapeMapper(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Boolean axis_along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
            VoxelShaper prov = axis_along ^ facing.m_122434_() == Direction.Axis.Y ? shaper2 : shaper;
            return prov.get(facing);
        }).build();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ALONG_FIRST_AXIS});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43719_().m_122424_();
        boolean along = true;
        if (facing.m_122434_() == Direction.Axis.Y) {
            Direction player = ctx.m_8125_();
            if (player.m_122434_() == Direction.Axis.X) {
                along = false;
            }
        } else {
            along = ctx.m_7820_().m_122434_() == facing.m_122427_().m_122434_();
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)ALONG_FIRST_AXIS, (Comparable)Boolean.valueOf(along));
    }
}

