/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.battery.BatteryBlockEntity;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.CustomConnectivityHandler;
import org.patryk3211.powergrid.electricity.battery.IMultiBlockBattery;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;

public class MultiBlockBatteryEntity
extends BatteryBlockEntity
implements IMultiBlockBattery {
    protected int width = 1;
    protected int height = 1;
    protected boolean updateConnectivity;
    private boolean rewire;
    protected BlockPos lastKnownPos;
    protected BlockPos controller;

    public MultiBlockBatteryEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.updateBehaviour();
        this.sendData();
    }

    @Override
    public void updateParameters() {
        if (this.energy <= 0.0 || this.sourceCoupling == null) {
            return;
        }
        float chargeLevel = (float)(this.energy / this.capacity);
        this.sourceCoupling.setVoltage(this.spec.calculateVoltage(chargeLevel));
        this.sourceCoupling.setResistance(this.spec.calculateResistance(chargeLevel) / (float)this.getSize());
    }

    private void overheated() {
        assert (this.f_58857_ != null);
        if (this.isController()) {
            GlobalElectricNetworks.getWorldNetworks(this.f_58857_).findConnectedWires(this.electricBehaviour).forEach(wire -> {
                if (wire.owner != null) {
                    wire.owner.m_6074_();
                } else {
                    wire.remove();
                }
            });
            RandomSource r = this.f_58857_.f_46441_;
            int x = this.f_58858_.m_123341_() + r.m_216339_(0, this.getWidth());
            int y = this.f_58858_.m_123342_() + r.m_216339_(0, this.getHeight());
            int z = this.f_58858_.m_123343_() + r.m_216339_(0, this.getWidth());
            ThermalBehaviour.explode(this.f_58857_, new BlockPos(x, y, z), this.m_58900_(), (float)this.getSize() * 0.25f);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.electricBehaviour = this.isController() ? new ElectricBehaviour(this) : new ProxyElectricBehaviour(this, this::getController);
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.behaviourFlags(1).overheatCallback(this::overheated);
            behaviours.add(this.thermalBehaviour);
        }
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CustomConnectivityHandler.formMulti(this);
    }

    @Override
    public void updateBehaviour() {
        List<TransmissionLinePart> wires = null;
        if (this.f_58857_ != null) {
            wires = GlobalElectricNetworks.getWorldNetworks(this.f_58857_).findConnectedWires(this.electricBehaviour);
        }
        if (this.isController()) {
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                this.electricBehaviour = new ElectricBehaviour(this);
                this.electricBehaviour.inheritConnections(proxy);
                this.attachBehaviourLate(this.electricBehaviour);
            }
            this.updateThermals();
            if (this.thermalBehaviour != null) {
                this.thermalBehaviour.track(null);
            }
        } else {
            MultiBlockBatteryEntity controller;
            if (!(this.electricBehaviour instanceof ProxyElectricBehaviour)) {
                ElectricBehaviour old = this.electricBehaviour;
                this.electricBehaviour = new ProxyElectricBehaviour(this, this::getController);
                this.electricBehaviour.inheritConnections(old);
                old.pause();
                this.attachBehaviourLate(this.electricBehaviour);
                this.sourceCoupling = null;
            }
            if ((controller = this.getControllerBE()) != null && this.thermalBehaviour != null) {
                this.thermalBehaviour.track(controller.thermalBehaviour);
            }
        }
        if (wires != null) {
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
        this.updateParameters();
    }

    @Override
    public void markRewire() {
        this.rewire = true;
        this.sendData();
    }

    @Override
    public void tick() {
        MultiBlockBatteryEntity controller;
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_)) {
            this.onPositionChanged();
            return;
        }
        if (!this.isController() && (controller = this.getControllerBE()) != null && this.thermalBehaviour != null) {
            this.thermalBehaviour.track(this.getControllerBE().thermalBehaviour);
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.f_58857_.f_46443_ && this.rewire) {
            this.updateBehaviour();
            this.rewire = false;
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    public MultiBlockBatteryEntity getControllerBE() {
        if (this.isController() || !this.m_58898_()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof MultiBlockBatteryEntity) {
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)blockEntity;
            return battery;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.updateBehaviour();
        this.notifyUpdate();
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            double currentBlocks = (double)this.spec.getMaxCharge() / this.capacity;
            this.capacity = this.spec.getMaxCharge();
            this.energy /= currentBlocks;
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.updateBehaviour();
        this.notifyUpdate();
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
        }
        int blocks = this.width * this.width * this.height;
        this.capacity = this.spec.getMaxCharge() * (float)blocks;
        super.read(compound, clientPacket);
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.f_58857_ != null && (changeOfController || prevSize != this.width || prevHeight != this.height)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
            this.updateBehaviour();
        }
        if (clientPacket && compound.m_128471_("Rewire")) {
            this.rewire = true;
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        super.write(compound, clientPacket);
        if (clientPacket && this.rewire) {
            compound.m_128379_("Rewire", true);
            this.rewire = false;
        }
    }

    public double getIndividualEnergy() {
        MultiBlockBatteryEntity controller = this.getControllerBE();
        if (controller == null) {
            return this.getEnergy();
        }
        return controller.getEnergy() / (double)controller.getSize();
    }

    public void invalidate() {
        if (this.f_58857_.f_46443_) {
            WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(this.f_58857_);
            List<TransmissionLinePart> wires = global.findConnectedWires(this.electricBehaviour);
            global.deferredRewire(wires);
        }
        super.invalidate();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        if (this.isController()) {
            this.capacity = this.spec.getMaxCharge() * (float)this.getSize();
            this.updateThermals();
            this.updateParameters();
        }
        this.notifyUpdate();
    }

    private void updateThermals() {
        if (this.thermalBehaviour != null) {
            Block block = this.m_58900_().m_60734_();
            float factor = ThermalBehaviour.dissipationFactor(ThermalValues.getPower(block), 175.0f);
            this.thermalBehaviour.setDissipationFactor(factor * (float)this.getSize());
            this.thermalBehaviour.setThermalMass(ThermalValues.getMass(block) * (float)this.getSize());
        }
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 5;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public BatterySpec getSpec() {
        return this.spec;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void inheritEnergy(IMultiBlockBattery part) {
        this.energy += part.getEnergy();
        part.setEnergy(0.0);
    }

    @Override
    public void setCapacitySize(int blocks) {
        this.capacity = this.spec.getMaxCharge() * (float)blocks;
    }

    @Override
    public int getSize() {
        return Math.max(this.width * this.width * this.height, 1);
    }
}

