/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.BridgeElectricBehaviour;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlock;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class DeviceConnectorBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    protected BridgeElectricBehaviour proxyBehaviour;
    protected SwitchedWire converterWire;

    public DeviceConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected BridgeElectricBehaviour makeBridge() {
        return new BridgeElectricBehaviour(this, this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)DeviceConnectorBlock.FACING)), () -> this.converterWire);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.proxyBehaviour = this.makeBridge();
        this.electricBehaviour = this.proxyBehaviour;
        behaviours.add(this.electricBehaviour);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.converterWire = builder.connectSwitch(100.0f, builder.terminalNode(0), builder.terminalNode(1));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.proxyBehaviour.isFE()) {
            return false;
        }
        Lang.translate("gui.device_connector.info_header", new Object[0]).forGoggles(tooltip);
        Lang.translate("gui.device_connector.supplying", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        LangBuilder unit = Lang.translate("gui.device_connector.supplying.unit", new Object[0]);
        float A = Math.abs(this.converterWire.current());
        Lang.number(this.proxyBehaviour.currentRate).add(Component.m_237113_((String)" ")).add(unit).style(ChatFormatting.AQUA).add(Lang.translate("gui.device_connector.for", new Object[0]).add(Lang.numberConstant((double)(A * A) * this.converterWire.getResistance())).add(Component.m_237113_((String)" ")).add(Unit.POWER.get()).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        Lang.translate("gui.device_connector.buffered", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        LangBuilder unit2 = Lang.translate("gui.device_connector.buffered.unit", new Object[0]);
        float V = Math.abs(this.converterWire.potentialDifference());
        Lang.number(this.proxyBehaviour.getBufferedAmount()).add(Component.m_237113_((String)" ")).add(unit2).style(ChatFormatting.AQUA).add(Lang.translate("gui.device_connector.for", new Object[0]).add(Lang.numberConstant(V)).add(Component.m_237113_((String)" ")).add(Unit.VOLTAGE.get()).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }
}

