/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.fan;

import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.DirectionalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.fan.ElectricFanBlockEntity;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;

public class ElectricFanBlock
extends DirectionalElectricBlock
implements IBE<ElectricFanBlockEntity>,
IHaveElectricProperties {
    private static final TerminalBoundingBox[] UP_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 5.0, 6.0, 7.0, 6.0, 7.0, 9.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 10.0, 6.0, 7.0, 11.0, 7.0, 9.0).withColor(3899647)};
    private static final VoxelShape SHAPE_UP = Shapes.m_83110_((VoxelShape)ElectricFanBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)ElectricFanBlock.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));

    public ElectricFanBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60955_());
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)SHAPE_UP, (Direction)Direction.UP);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each(UP_TERMINALS, terminal -> switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> terminal;
            case Direction.DOWN -> terminal.rotateAroundX(180);
            case Direction.NORTH -> terminal.rotateAroundX(90);
            case Direction.SOUTH -> terminal.rotateAroundX(-90);
            case Direction.EAST -> terminal.rotateAroundX(90).rotateAroundY(90);
            case Direction.WEST -> terminal.rotateAroundX(90).rotateAroundY(-90);
        })).withShapeMapper(state -> shaper.get((Direction)state.m_61143_((Property)FACING))).build());
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState placedOn = world.m_8055_(pos.m_121945_(face.m_122424_()));
        BlockState placedOnOpposite = world.m_8055_(pos.m_121945_(face));
        if (AbstractChuteBlock.isChute((BlockState)placedOn)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face.m_122424_());
        }
        if (AbstractChuteBlock.isChute((BlockState)placedOnOpposite)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face);
        }
        Direction preferredFacing = context.m_7820_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? preferredFacing : preferredFacing.m_122424_()));
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        super.m_7742_(stateIn, worldIn, pos, flags, count);
        this.blockUpdate(stateIn, worldIn, pos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    protected void blockUpdate(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (worldIn instanceof WrappedLevel) {
            return;
        }
        this.notifyFanBlockEntity(worldIn, pos);
    }

    protected void notifyFanBlockEntity(LevelAccessor world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, ElectricFanBlockEntity::blockInFrontChanged);
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        this.blockUpdate(newState, (LevelAccessor)context.m_43725_(), context.m_8083_());
        return newState;
    }

    public Class<ElectricFanBlockEntity> getBlockEntityClass() {
        return ElectricFanBlockEntity.class;
    }

    public BlockEntityType<? extends ElectricFanBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.ELECTRIC_FAN.get();
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        Voltage.max(this.resistance() * 4.0f, player, tooltip);
    }
}

