/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class PowerGaugeBlockEntity
extends GaugeBlockEntity {
    private static final float[] MAX_VALUES = new float[]{20.0f, 200.0f, 2000.0f, 20000.0f};
    private ElectricWire series;
    private ElectricWire shunt;

    public PowerGaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.gaugeValue = new GaugeValueBehaviour((Component)Component.m_237115_((String)"powergrid.devices.gauge.power"), (Component)Unit.POWER.get().component(), MAX_VALUES, this, (ValueBoxTransform)new GaugeBlockEntity.BoxTransform());
        this.gaugeValue.withCallback(i -> {
            this.maxValue = MAX_VALUES[i];
            this.sendData();
        });
        behaviours.add((BlockEntityBehaviour)this.gaugeValue);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxValue = MAX_VALUES[this.gaugeValue.getValue()];
    }

    @Override
    public void tick() {
        float current = Math.abs(this.getValue());
        this.dialTarget = current > this.maxValue ? 1.125f : current / this.maxValue;
        this.applyPower(this.series);
        super.tick();
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        float resistance = this.resistance();
        builder.setTerminalCount(3);
        this.series = builder.connect(resistance, builder.terminalNode(0), builder.terminalNode(1));
        this.shunt = builder.connect(20000.0f, builder.terminalNode(0), builder.terminalNode(2));
    }

    @Override
    public float getValue() {
        return this.series.current() * this.shunt.potentialDifference();
    }

    @Override
    public Unit getUnit() {
        return Unit.POWER;
    }

    public static ChatFormatting measurementColor(float value, float maxValue) {
        if ((double)value < (double)maxValue * 0.01) {
            return ChatFormatting.DARK_GRAY;
        }
        if ((double)value < (double)maxValue * 0.5) {
            return ChatFormatting.DARK_AQUA;
        }
        if ((double)value < (double)maxValue * 0.75) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.RED;
    }

    public static void addTooltip(List<Component> tooltip, float power, float maxValue) {
        Lang.builder().translate("gui.power_meter.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        power = (float)Math.round(power * 100.0f) / 100.0f;
        String powerText = String.format("%.2f", Float.valueOf(power));
        if (Math.abs(power) > maxValue) {
            powerText = power > 0.0f ? String.format("> %.2f", Float.valueOf(maxValue)) : String.format("< %.2f", Float.valueOf(-maxValue));
        }
        Lang.builder().text(powerText).add(Component.m_237113_((String)" ")).add(Unit.POWER.get()).style(PowerGaugeBlockEntity.measurementColor(Math.abs(power), maxValue)).forGoggles(tooltip, 1);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        PowerGaugeBlockEntity.addTooltip(tooltip, this.getValue(), this.maxValue);
        return true;
    }
}

