/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class VoltageGaugeBlockEntity
extends GaugeBlockEntity {
    private static final float[] MAX_VALUES = new float[]{2.0f, 20.0f, 200.0f, 2000.0f};
    private IElectricNode node1;
    private IElectricNode node2;

    public VoltageGaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.gaugeValue = new GaugeValueBehaviour((Component)Component.m_237115_((String)"powergrid.devices.gauge.voltage"), (Component)Unit.VOLTAGE.get().component(), MAX_VALUES, this, (ValueBoxTransform)new GaugeBlockEntity.BoxTransform());
        this.gaugeValue.withCallback(i -> {
            this.maxValue = MAX_VALUES[i];
            this.sendData();
        });
        behaviours.add((BlockEntityBehaviour)this.gaugeValue);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxValue = MAX_VALUES[this.gaugeValue.getValue()];
    }

    @Override
    public void tick() {
        float potential = Math.abs(this.getValue());
        this.dialTarget = potential > this.maxValue ? 1.125f : potential / this.maxValue;
        super.tick();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.node1 = builder.terminalNode(0);
        this.node2 = builder.terminalNode(1);
        builder.connect(20000.0f, this.node1, this.node2);
    }

    @Override
    public float getValue() {
        return this.node1.getVoltage() - this.node2.getVoltage();
    }

    @Override
    public Unit getUnit() {
        return Unit.VOLTAGE;
    }

    public static ChatFormatting measurementColor(float value, float maxValue) {
        if ((double)value < (double)maxValue * 0.01) {
            return ChatFormatting.DARK_GRAY;
        }
        if ((double)value < (double)maxValue * 0.5) {
            return ChatFormatting.GREEN;
        }
        if ((double)value < (double)maxValue * 0.75) {
            return ChatFormatting.BLUE;
        }
        return ChatFormatting.LIGHT_PURPLE;
    }

    public static void addTooltip(List<Component> tooltip, float potential, float maxValue) {
        Lang.builder().translate("gui.voltage_meter.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        potential = (float)Math.round(potential * 100.0f) / 100.0f;
        String voltageText = String.format("%.2f", Float.valueOf(potential));
        if (Math.abs(potential) > maxValue) {
            voltageText = potential > 0.0f ? String.format("> %.2f", Float.valueOf(maxValue)) : String.format("< %.2f", Float.valueOf(-maxValue));
        }
        Lang.builder().text(voltageText).add(Component.m_130674_((String)" ")).add(Unit.VOLTAGE.get()).style(VoltageGaugeBlockEntity.measurementColor(Math.abs(potential), maxValue)).forGoggles(tooltip, 1);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        VoltageGaugeBlockEntity.addTooltip(tooltip, this.getValue(), this.maxValue);
        return true;
    }
}

