/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.fixture;

import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LightFixtureBlock
extends ElectricBlock
implements IBE<LightFixtureBlockEntity>,
IAcceptCord {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)2);
    public static final BooleanProperty ALONG_FIRST_AXIS = CustomProperties.ALONG_FIRST_AXIS;
    private static final TerminalBoundingBox[] UP_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 2.5, 1.5, 6.5, 4.5, 3.5, 9.5), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 11.5, 1.5, 6.5, 13.5, 3.5, 9.5)};
    private static final VoxelShape SHAPE_UP = LightFixtureBlock.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)3.0, (double)12.5);
    Vec3 modelOffset = Vec3.f_82478_;

    public LightFixtureBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(state -> switch ((Integer)state.m_61143_((Property)POWER)) {
            case 1 -> 10;
            case 2 -> 15;
            default -> 0;
        }));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)SHAPE_UP, (Direction)Direction.UP);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStatesExcept(state -> BlockStateTerminalCollection.each(UP_TERMINALS, terminal -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case UP: {
                    TerminalBoundingBox terminalBoundingBox = terminal;
                    break;
                }
                case DOWN: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(Rotation.CLOCKWISE_180);
                    break;
                }
                case NORTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(Rotation.CLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case EAST: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(Rotation.CLOCKWISE_90).rotateAroundY(Rotation.CLOCKWISE_90);
                    break;
                }
                case WEST: {
                    TerminalBoundingBox terminalBoundingBox = terminal = terminal.rotateAroundX(Rotation.CLOCKWISE_90).rotateAroundY(Rotation.COUNTERCLOCKWISE_90);
                }
            }
            if (!((Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS)).booleanValue()) {
                terminal = terminal.rotate(facing.m_122434_(), Rotation.CLOCKWISE_90);
            }
            return terminal;
        }), new Property[]{POWER}).withShapeMapper(state -> shaper.get((Direction)state.m_61143_((Property)FACING))).build());
    }

    public static <B extends LightFixtureBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> setBulbModelOffset(Vec3 modelOffset) {
        return b -> {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> b.onRegister(block -> {
                block.modelOffset = modelOffset;
            }));
            return b;
        };
    }

    public static <B extends LightFixtureBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> setBulbModelOffset(float x, float y, float z) {
        return b -> {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> b.onRegister(block -> {
                block.modelOffset = new Vec3((double)x, (double)y, (double)z);
            }));
            return b;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, POWER, ALONG_FIRST_AXIS});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return LightFixtureBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_5484_(facing, -1), (Direction)facing);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return direction == facing.m_122424_() && !this.m_7898_(state, (LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction player;
        Direction facing = ctx.m_43719_();
        boolean along = true;
        if (facing.m_122434_() == Direction.Axis.Y && (player = ctx.m_8125_()).m_122434_() == Direction.Axis.X) {
            along = false;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)ALONG_FIRST_AXIS, (Comparable)Boolean.valueOf(along));
    }

    @Override
    public int terminalCount() {
        return 2;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || stack.m_41720_() instanceof ILightBulb) {
            return this.onBlockEntityUse((BlockGetter)world, pos, be -> be.replaceBulb(player, hand, stack) ? InteractionResult.SUCCESS : InteractionResult.FAIL);
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        LightFixtureBlockEntity fixture;
        LightBulbState bulb;
        BlockEntity be = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (be instanceof LightFixtureBlockEntity && (bulb = (fixture = (LightFixtureBlockEntity)be).getBulbState()) != null && !bulb.isBurned()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, params));
            drops.add(new ItemStack((ItemLike)fixture.getBulbState().getItem(), 1));
            return drops;
        }
        return super.m_49635_(state, params);
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
    }

    public Class<LightFixtureBlockEntity> getBlockEntityClass() {
        return LightFixtureBlockEntity.class;
    }

    public BlockEntityType<? extends LightFixtureBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.LIGHT_FIXTURE.get();
    }

    @Override
    @Nullable
    public AutoCordEndpoint getEndpoint(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        Vec3i normal = facing.m_122436_();
        Vec3 point = center.m_82520_((double)normal.m_123341_() * -0.40625, (double)normal.m_123342_() * -0.40625, (double)normal.m_123343_() * -0.40625);
        return new AutoCordEndpoint(context.m_8083_(), 0, 1, point, this.renderPlug() ? context.m_43719_() : null);
    }
}

