/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.patryk3211.powergrid.collections.ModdedParticles;
import org.patryk3211.powergrid.electricity.particles.SparkParticle;

public class SparkParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SparkParticleData> {
    public static final ParticleOptions.Deserializer<SparkParticleData> FACTORY = new ParticleOptions.Deserializer<SparkParticleData>(){

        public SparkParticleData fromCommand(ParticleType<SparkParticleData> type, StringReader reader) throws CommandSyntaxException {
            return new SparkParticleData();
        }

        public SparkParticleData fromNetwork(ParticleType<SparkParticleData> type, FriendlyByteBuf buf) {
            return new SparkParticleData(buf.readInt(), buf.readBoolean(), buf.readBoolean());
        }
    };
    public static final SparkParticleData INSTANCE = new SparkParticleData();
    public static final Codec<SparkParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("life").forGetter(SparkParticleData::getLife), (App)Codec.BOOL.fieldOf("collision").forGetter(SparkParticleData::getCollision), (App)Codec.BOOL.fieldOf("gravity").forGetter(SparkParticleData::getGravity)).apply((Applicative)instance, SparkParticleData::new));
    private final int life;
    private final boolean collision;
    private final boolean gravity;

    public SparkParticleData() {
        this(-1, true, true);
    }

    public SparkParticleData(int life, boolean collision, boolean gravity) {
        this.life = life;
        this.collision = collision;
        this.gravity = gravity;
    }

    public int getLife() {
        return this.life;
    }

    public boolean getCollision() {
        return this.collision;
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public static void explodeParticles(Level world, float x, float y, float z, Direction dir, int count) {
        RandomSource r = world.f_46441_;
        Vector3f offset = dir.m_253071_().mul(0.1f);
        for (int i = 0; i < count; ++i) {
            Vector3f heading = dir.m_253071_();
            float pitch = (float)((double)(r.m_188501_() - 0.5f) * Math.PI) * 0.9f;
            float yaw = (float)((double)(r.m_188501_() - 0.5f) * Math.PI) * 0.9f;
            heading.rotateX(pitch).rotateY(yaw);
            heading.mul(r.m_188501_() * 1.0f);
            world.m_7106_((ParticleOptions)INSTANCE, (double)(x + offset.x), (double)(y + offset.y), (double)(z + offset.z), (double)heading.x, (double)heading.y, (double)heading.z);
        }
    }

    public ParticleType<?> m_6012_() {
        return ModdedParticles.CUBE_SPARK;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.life);
        buf.writeBoolean(this.collision);
        buf.writeBoolean(this.gravity);
    }

    public String m_5942_() {
        return BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()).toString();
    }

    public ParticleOptions.Deserializer<SparkParticleData> getDeserializer() {
        return FACTORY;
    }

    public Codec<SparkParticleData> getCodec(ParticleType<SparkParticleData> type) {
        return CODEC;
    }

    public ParticleEngine.SpriteParticleRegistration<SparkParticleData> getMetaFactory() {
        return SparkParticle.Factory::new;
    }
}

