/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.node;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.sim.node.CouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.solver.IAdmittanceAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;

public class VoltageSourceCoupling
extends CouplingNode
implements IStaticResidual {
    protected final IElectricNode positive;
    @Nullable
    protected final IElectricNode negative;
    private float voltage;
    private float resistance;

    public VoltageSourceCoupling(IElectricNode positive, @Nullable IElectricNode negative, float resistance) {
        this.positive = positive;
        this.negative = negative;
        this.resistance = resistance;
    }

    public VoltageSourceCoupling(IElectricNode positive, @Nullable IElectricNode negative, Number resistance) {
        this.positive = positive;
        this.negative = negative;
        this.resistance = resistance.floatValue();
    }

    public VoltageSourceCoupling(IElectricNode positive, @Nullable IElectricNode negative, float resistance, float voltage) {
        this(positive, negative, resistance);
        this.setVoltage(voltage);
    }

    public void setVoltage(float voltage) {
        this.voltage = voltage;
    }

    public void setResistance(float resistance) {
        if (this.network != null) {
            this.network.alterConductanceMatrix(this.index, this.index, -(resistance - this.resistance));
        }
        this.resistance = resistance;
    }

    @Override
    public void couple(IAdmittanceAdder admittance) {
        admittance.add(this.index, this.positive.getIndex(), 1.0);
        admittance.add(this.positive.getIndex(), this.index, 1.0);
        admittance.add(this.index, this.index, -this.resistance);
        if (this.negative != null) {
            admittance.add(this.index, this.negative.getIndex(), -1.0);
            admittance.add(this.negative.getIndex(), this.index, -1.0);
        }
    }

    @Override
    public Collection<IElectricNode> coupledNodes() {
        if (this.negative == null) {
            return List.of(this.positive);
        }
        return List.of(this.positive, this.negative);
    }

    public float getCurrent() {
        return (float)this.getStateValue();
    }

    public float getVoltage() {
        return this.voltage;
    }

    public float getResistance() {
        return this.resistance;
    }

    public IElectricNode getPositive() {
        return this.positive;
    }

    @Nullable
    public IElectricNode getNegative() {
        return this.negative;
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        residual.add(this.index, this.voltage);
    }

    @Override
    public List<INode> affectedNodes() {
        if (this.negative != null) {
            return List.of(this.positive, this.negative);
        }
        return List.of(this.positive);
    }
}

