/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.wire.CurveParameters;
import org.patryk3211.powergrid.electricity.wire.HangingWireRenderer;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.CordItem;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SocketEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SplitCordEndpoint;

@OnlyIn(value=Dist.CLIENT)
public class CordRenderer
extends EntityRenderer<CordEntity> {
    public CordRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @NotNull
    public ResourceLocation getTextureLocation(CordEntity entity) {
        return entity.getWireItem().getWireTexture();
    }

    private static void renderPlug(PoseStack matrices, MultiBufferSource consumers, BlockState referenceState, Direction facing, float x, float y, float z, int light) {
        SuperByteBuffer model = CachedBuffers.partial((PartialModel)ModdedPartialModels.PLUG, (BlockState)referenceState);
        switch (facing) {
            case NORTH: {
                z -= 0.1875f;
                break;
            }
            case SOUTH: {
                z += 0.1875f;
                break;
            }
            case WEST: {
                x -= 0.1875f;
                break;
            }
            case EAST: {
                x += 0.1875f;
                break;
            }
            case DOWN: {
                y -= 0.1875f;
                break;
            }
            case UP: {
                y += 0.1875f;
            }
        }
        ((SuperByteBuffer)((SuperByteBuffer)model.light(light).translate(x, y, z)).rotateToFace(facing)).renderInto(matrices, consumers.m_6299_(RenderType.m_110451_()));
    }

    public void render(CordEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.renderParams == null) {
            return;
        }
        if (entity.isOverheated()) {
            return;
        }
        VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        assert (entity.renderParams instanceof CurveParameters);
        CurveParameters rp = (CurveParameters)entity.renderParams;
        float thicknessOffset = (float)entity.m_19879_() / 16.0f;
        int color = entity.getColor() | 0xFF000000;
        Vec3 pos = entity.m_20182_();
        Level world = entity.m_9236_();
        rp.runForSegments((x1, y1, z1, x2, y2, z2, offset, length, first, last) -> {
            BlockPos blockPos = BlockPos.m_274561_((double)((double)(x1 + x2) * 0.5 + pos.f_82479_), (double)((double)(y1 + y2) * 0.5 + pos.f_82480_), (double)((double)(z1 + z2) * 0.5 + pos.f_82481_));
            int sky = world.m_45517_(LightLayer.SKY, blockPos);
            int block = world.m_45517_(LightLayer.BLOCK, blockPos);
            int currentLight = LightTexture.m_109885_((int)block, (int)sky);
            if (first) {
                AutoCordEndpoint auto;
                Direction facing;
                IWireEndpoint endpoint = entity.getEndpoint1();
                if (endpoint instanceof SplitCordEndpoint) {
                    SplitCordEndpoint split = (SplitCordEndpoint)endpoint;
                    Vec3 p1 = split.getEndpoint1().getExactPosition(world);
                    Vec3 p2 = split.getEndpoint2().getExactPosition(world);
                    Vec3 normal = rp.getNormal();
                    Vec3 direction = new Vec3((double)x2 - p1.f_82479_ + pos.f_82479_, (double)y2 - p1.f_82480_ + pos.f_82480_, (double)z2 - p1.f_82481_ + pos.f_82481_);
                    Vec3 v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    Vec3 smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    Vec3 smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)(p1.f_82479_ - pos.f_82479_), (float)(p1.f_82480_ - pos.f_82480_), (float)(p1.f_82481_ - pos.f_82481_), (float)((double)x2 - (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 + normal.f_82479_ / 32.0), (float)((double)y2 - (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 + normal.f_82480_ / 32.0), (float)((double)z2 - (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 + normal.f_82481_ / 32.0), smallCross1, smallCross2, currentLight, -5231066, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    direction = new Vec3((double)x2 - p2.f_82479_ + pos.f_82479_, (double)y2 - p2.f_82480_ + pos.f_82480_, (double)z2 - p2.f_82481_ + pos.f_82481_);
                    v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)(p2.f_82479_ - pos.f_82479_), (float)(p2.f_82480_ - pos.f_82480_), (float)(p2.f_82481_ - pos.f_82481_), (float)((double)x2 + (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 + normal.f_82479_ / 32.0), (float)((double)y2 + (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 + normal.f_82480_ / 32.0), (float)((double)z2 + (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 + normal.f_82481_ / 32.0), smallCross1, smallCross2, currentLight, -12827478, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    return;
                }
                if (endpoint instanceof SocketEndpoint) {
                    SocketEndpoint socket = (SocketEndpoint)endpoint;
                    CordRenderer.renderPlug(matrices, vertexConsumers, world.m_8055_(socket.getPosition()), socket.getFacing(world), x1, y1, z1, currentLight);
                } else if (endpoint instanceof AutoCordEndpoint && (facing = (auto = (AutoCordEndpoint)endpoint).getPlugFacing()) != null) {
                    CordRenderer.renderPlug(matrices, vertexConsumers, world.m_8055_(auto.getPosition()), facing.m_122424_(), x1, y1, z1, currentLight);
                }
            } else if (last) {
                AutoCordEndpoint auto;
                Direction facing;
                IWireEndpoint endpoint = entity.getEndpoint2();
                if (endpoint instanceof SplitCordEndpoint) {
                    SplitCordEndpoint split = (SplitCordEndpoint)endpoint;
                    Vec3 p1 = split.getEndpoint1().getExactPosition(world);
                    Vec3 p2 = split.getEndpoint2().getExactPosition(world);
                    Vec3 normal = rp.getNormal();
                    Vec3 direction = new Vec3((double)x1 - p1.f_82479_ + pos.f_82479_, (double)y1 - p1.f_82480_ + pos.f_82480_, (double)z1 - p1.f_82481_ + pos.f_82481_);
                    Vec3 v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    Vec3 smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    Vec3 smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)((double)x1 - (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 - normal.f_82479_ / 32.0), (float)((double)y1 - (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 - normal.f_82480_ / 32.0), (float)((double)z1 - (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 - normal.f_82481_ / 32.0), (float)(p1.f_82479_ - pos.f_82479_), (float)(p1.f_82480_ - pos.f_82480_), (float)(p1.f_82481_ - pos.f_82481_), smallCross1, smallCross2, currentLight, -5231066, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    direction = new Vec3((double)x1 - p2.f_82479_ + pos.f_82479_, (double)y1 - p2.f_82480_ + pos.f_82480_, (double)z1 - p2.f_82481_ + pos.f_82481_);
                    v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)((double)x1 + (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 - normal.f_82479_ / 32.0), (float)((double)y1 + (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 - normal.f_82480_ / 32.0), (float)((double)z1 + (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 - normal.f_82481_ / 32.0), (float)(p2.f_82479_ - pos.f_82479_), (float)(p2.f_82480_ - pos.f_82480_), (float)(p2.f_82481_ - pos.f_82481_), smallCross1, smallCross2, currentLight, -12827478, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    return;
                }
                if (endpoint instanceof SocketEndpoint) {
                    SocketEndpoint socket = (SocketEndpoint)endpoint;
                    CordRenderer.renderPlug(matrices, vertexConsumers, world.m_8055_(socket.getPosition()), socket.getFacing(world), x2, y2, z2, currentLight);
                } else if (endpoint instanceof AutoCordEndpoint && (facing = (auto = (AutoCordEndpoint)endpoint).getPlugFacing()) != null) {
                    CordRenderer.renderPlug(matrices, vertexConsumers, world.m_8055_(auto.getPosition()), facing.m_122424_(), x2, y2, z2, currentLight);
                }
            }
            HangingWireRenderer.renderSegment(matrices, vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity))), x1, y1, z1, x2, y2, z2, rp.cross1, rp.cross2, currentLight, color, rp.thickness, thicknessOffset, length, offset);
        });
    }

    public static void renderPreview(ICordEndpoint start, Vec3 end, PoseStack matrices, MultiBufferSource vertexConsumers, Level level, CordItem item, int color) {
        VertexConsumer buffer = vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)item.getWireTexture()));
        Vec3 startPos = start.getExactPosition(level);
        CurveParameters rp = new CurveParameters(startPos, end, item.getHorizontalCoefficient(), item.getVerticalCoefficient(), item.getWireThickness());
        int thicknessOffset = 0;
        matrices.m_85836_();
        Vec3 pos = new Vec3((startPos.f_82479_ + end.f_82479_) * 0.5, startPos.f_82480_, (startPos.f_82481_ + end.f_82481_) * 0.5);
        matrices.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        rp.runForSegments((x1, y1, z1, x2, y2, z2, offset, length, first, last) -> {
            int currentLight = 0xF000F0;
            if (first) {
                AutoCordEndpoint auto;
                Direction facing;
                if (start instanceof SplitCordEndpoint) {
                    SplitCordEndpoint split = (SplitCordEndpoint)start;
                    Vec3 p1 = split.getEndpoint1().getExactPosition(level);
                    Vec3 p2 = split.getEndpoint2().getExactPosition(level);
                    Vec3 normal = rp.getNormal();
                    Vec3 direction = new Vec3((double)x2 - p1.f_82479_ + pos.f_82479_, (double)y2 - p1.f_82480_ + pos.f_82480_, (double)z2 - p1.f_82481_ + pos.f_82481_);
                    Vec3 v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    Vec3 smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    Vec3 smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)(p1.f_82479_ - pos.f_82479_), (float)(p1.f_82480_ - pos.f_82480_), (float)(p1.f_82481_ - pos.f_82481_), (float)((double)x2 - (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 + normal.f_82479_ / 32.0), (float)((double)y2 - (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 + normal.f_82480_ / 32.0), (float)((double)z2 - (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 + normal.f_82481_ / 32.0), smallCross1, smallCross2, currentLight, -5231066, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    direction = new Vec3((double)x2 - p2.f_82479_ + pos.f_82479_, (double)y2 - p2.f_82480_ + pos.f_82480_, (double)z2 - p2.f_82481_ + pos.f_82481_);
                    v1 = new Vec3(1.0 - direction.f_82479_, 1.0 - direction.f_82480_, 1.0 - direction.f_82481_);
                    smallCross1 = v1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    smallCross2 = smallCross1.m_82537_(direction).m_82541_().m_82490_((double)rp.thickness * 0.25);
                    HangingWireRenderer.renderSegment(matrices, buffer, (float)(p2.f_82479_ - pos.f_82479_), (float)(p2.f_82480_ - pos.f_82480_), (float)(p2.f_82481_ - pos.f_82481_), (float)((double)x2 + (smallCross1.f_82479_ + smallCross2.f_82479_) * 0.5 + normal.f_82479_ / 32.0), (float)((double)y2 + (smallCross1.f_82480_ + smallCross2.f_82480_) * 0.5 + normal.f_82480_ / 32.0), (float)((double)z2 + (smallCross1.f_82481_ + smallCross2.f_82481_) * 0.5 + normal.f_82481_ / 32.0), smallCross1, smallCross2, currentLight, -12827478, rp.thickness * 0.5f, thicknessOffset, length * 2.0f, offset);
                    return;
                }
                if (start instanceof SocketEndpoint) {
                    SocketEndpoint socket = (SocketEndpoint)start;
                    CordRenderer.renderPlug(matrices, vertexConsumers, level.m_8055_(socket.getPosition()), socket.getFacing(level), x1, y1, z1, currentLight);
                } else if (start instanceof AutoCordEndpoint && (facing = (auto = (AutoCordEndpoint)start).getPlugFacing()) != null) {
                    CordRenderer.renderPlug(matrices, vertexConsumers, level.m_8055_(auto.getPosition()), facing.m_122424_(), x1, y1, z1, currentLight);
                }
            }
            HangingWireRenderer.renderSegment(matrices, vertexConsumers.m_6299_(RenderType.m_110458_((ResourceLocation)item.getWireTexture())), x1, y1, z1, x2, y2, z2, rp.cross1, rp.cross2, currentLight, color, rp.thickness, thicknessOffset, length, offset);
        });
        matrices.m_85849_();
    }
}

